このマニュアルは、Pythonプログラム `vdPauw_f.py` の機能、原理、使用方法について詳細に説明します。

---

# vdPauw_f.py マニュアル

## 1. プログラムの目的

本プログラム `vdPauw_f.py` は、van der Pauw法における抵抗率の補正因子 $f$ を、抵抗比 $r = R_{ab,cd} / R_{ad,bc}$ の関数として数値的に計算し、その結果をプロットおよびデータファイルとして出力します。これにより、van der Pauw法で測定された抵抗値から正確なシート抵抗を求めるために必要な補正因子を、広範囲の抵抗比に対して得ることができます。

## 2. 原理

### 2.1. van der Pauwの基本式

van der Pauwの測定法では、薄膜サンプルのシート抵抗 $R_S$ は、直交する方向で測定された二つの抵抗値 $R_{ab,cd}$ と $R_{ad,bc}$ から以下の関係式によって求められます。

$$
\exp\left(-\pi \frac{R_{ab,cd}}{R_S}\right) + \exp\left(-\pi \frac{R_{ad,bc}}{R_S}\right) = 1
$$

### 2.2. 補正因子 $f$ の導入とプログラム中の式

本プログラムでは、補正因子 $f$ を導入し、シート抵抗 $R_S$ を以下のように定義します。

$$
R_S = \frac{\pi}{\ln 2} f \frac{R_{ab,cd} + R_{ad,bc}}{2}
$$

ここで、抵抗比 $r$ を以下のように定義します。

$$
r = \frac{R_{ab,cd}}{R_{ad,bc}}
$$

この定義から、$R_{ab,cd} = r R_{ad,bc}$ となり、$R_{ab,cd} + R_{ad,bc} = (r+1)R_{ad,bc}$ と書けます。
上記の $R_S$ の定義式に $R_{ab,cd}$ と $R_{ad,bc}$ の関係を代入すると、

$$
R_S = \frac{\pi}{\ln 2} f \frac{(r+1)R_{ad,bc}}{2}
$$

となります。
これを van der Pauwの基本式に代入するために、$R_{ab,cd}/R_S$ と $R_{ad,bc}/R_S$ の項を計算します。

$$
\frac{R_{ab,cd}}{R_S} = \frac{r R_{ad,bc}}{\frac{\pi}{\ln 2} f \frac{(r+1)R_{ad,bc}}{2}} = \frac{2r \ln 2}{\pi f (r+1)}
$$

$$
\frac{R_{ad,bc}}{R_S} = \frac{R_{ad,bc}}{\frac{\pi}{\ln 2} f \frac{(r+1)R_{ad,bc}}{2}} = \frac{2 \ln 2}{\pi f (r+1)}
$$

これらを van der Pauwの基本式に代入すると、

$$
\exp\left(-\pi \left( \frac{2r \ln 2}{\pi f (r+1)} \right)\right) + \exp\left(-\pi \left( \frac{2 \ln 2}{\pi f (r+1)} \right)\right) = 1
$$

整理すると、以下の $f$ と $r$ の関係式が得られます。

$$
\exp\left(-\frac{2r \ln 2}{f (r+1)}\right) + \exp\left(-\frac{2 \ln 2}{f (r+1)}\right) = 1
$$

本プログラムの `vdp_residual` 関数は、この方程式を $0$ となる形で表現しています。

$$
\exp\left(-\frac{\ln 2}{f} \frac{2r}{r+1}\right) + \exp\left(-\frac{\ln 2}{f} \frac{2}{r+1}\right) - 1 = 0
$$

### 2.3. Newton法による数値計算

上記の方程式は解析的に $f$ について解くことが困難であるため、本プログラムではニュートン法 (Newton-Raphson method) を用いて数値的に解を求めます。ニュートン法は、関数 $G(f)=0$ の根を探索する反復法であり、初期値 $f_0$ と関数の導関数 $G'(f)$ を与えることで、次の近似解 $f_{n+1} = f_n - G(f_n)/G'(f_n)$ を計算し、高速かつ安定した収束が期待できます。

プログラムでは、ニュートン法の反復計算の安定性と速度を向上させるため、以下の導関数 `vdp_derivative` を使用しています。関数を $G(f,r)$ とすると、

$$
G(f,r) = \exp\left(-\frac{\ln 2}{f} \frac{2r}{r+1}\right) + \exp\left(-\frac{\ln 2}{f} \frac{2}{r+1}\right) - 1
$$

$C_1 = \ln 2 \frac{2r}{r+1}$ および $C_2 = \ln 2 \frac{2}{r+1}$ と置くと、

$$
G(f,r) = \exp\left(-\frac{C_1}{f}\right) + \exp\left(-\frac{C_2}{f}\right) - 1
$$

$f$ に関する導関数 $\frac{\partial G}{\partial f}$ は以下のようになります。

$$
\frac{\partial G}{\partial f} = \frac{\partial}{\partial f} \left( \exp\left(-\frac{C_1}{f}\right) \right) + \frac{\partial}{\partial f} \left( \exp\left(-\frac{C_2}{f}\right) \right)
$$

$$
\frac{\partial G}{\partial f} = \exp\left(-\frac{C_1}{f}\right) \cdot \left( \frac{C_1}{f^2} \right) + \exp\left(-\frac{C_2}{f}\right) \cdot \left( \frac{C_2}{f^2} \right)
$$

これはプログラムの `vdp_derivative` 関数に実装されている式と一致します。

### 2.4. 継続法による安定化

広範囲の $r$ 値に対して安定して解を得るために、「継続法 (continuation method)」を採用しています。これは、$r=1$ のときに $f=1$ という既知の解からスタートし、$r$ の値を少しずつ変化させながら、直前の $r$ で得られた $f$ の解を次の計算の初期値として利用することで、ニュートン法の収束を助ける手法です。これにより、ニュートン法が初期値に強く依存することによる収束不良を防ぎます。

## 3. 使い方 (Usage)

### 3.1. 必要なライブラリ

本プログラムを実行するには、以下のPythonライブラリが必要です。

*   `numpy`: 数値計算
*   `matplotlib`: グラフ描画
*   `scipy`: 最適化 (ニュートン法)
*   `pandas`: データ処理、CSV出力

これらのライブラリがインストールされていない場合は、以下のコマンドをターミナルまたはコマンドプロンプトで実行してインストールしてください。

```bash
pip install numpy matplotlib scipy pandas
```

### 3.2. プログラムの実行

プログラムを実行するには、ターミナルまたはコマンドプロンプトで以下のコマンドを入力します。

```bash
python vdPauw_f.py
```

プログラムは自動的に $r$ の値を 1 から 1000 まで対数スケールで300点生成し、それぞれの $r$ に対する $f$ の値を計算します。計算結果はCSVファイルに保存され、またグラフとして描画・保存されます。

## 4. 出力ファイル

プログラムを実行すると、以下のファイルが生成されます。

*   `vdp_f_results.csv`: 計算された $r$ と $f$ の値を含むデータファイル。
*   `vdp_f_plot.png`: $r$ 対 $f$ の関係をプロットした画像ファイル。

## 5. 使用例

コマンドプロンプトで `python vdPauw_f.py` を実行すると、以下のようなメッセージが表示され、ファイルが生成されます。

```
✅ 計算結果を 'vdp_f_results.csv' に保存しました。
✅ プロット図を 'vdp_f_plot.png' に保存しました。
```

### 5.1. 出力ファイル `vdp_f_results.csv` の例

このCSVファイルには、抵抗比 $r$ とそれに対応する補正係数 $f$ の値が格納されています。

```csv
r,f
1.0,1.0
1.0234771746200213,0.9996020584283896
1.0475252876101918,0.9992047879105423
...
976.216398934335,0.08182963032545802
1000.0,0.08051662912444654
```

### 5.2. 出力画像 `vdp_f_plot.png` の概要

生成されるプロット画像は、横軸に対数スケールで抵抗比 $r = R_{ab,cd} / R_{ad,bc}$ を、縦軸に補正係数 $f$ をプロットしたグラフです。グラフには以下の特徴があります。

*   $r=1$ のとき $f=1$ となる理想的なケースが赤色の点線で示されます。
*   $r$ の増加に伴い、補正係数 $f$ が徐々に減少していく様子が確認できます。
*   グラフのタイトルは "van der Pauw Correction Factor $f$ (Newton Method)" です。
*   軸ラベルはそれぞれ "Resistance Ratio $r = R_{ab,cd} / R_{ad,bc}$" と "Correction Factor $f$" です。

このプロットにより、異なる抵抗比における補正因子 $f$ の挙動を視覚的に理解することができます。

---