`tkai_lib.py` ライブラリのマニュアルを以下に記述します。

---

# `tkai_lib` ライブラリ マニュアル

## 1) このライブラリの主な機能や目的

`tkai_lib` は、複数の大手AIおよび翻訳サービス（OpenAIのGPTシリーズ、Google Gemini、DeepL）へのアクセスを簡素化するためのPythonユーティリティライブラリです。主な目的は以下の通りです。

*   **多様なAIサービスの統合**: OpenAI (GPT-4, GPT-5系) および Google Gemini モデルへの統一されたインターフェースを提供し、テキスト生成などのAI機能を容易に利用できるようにします。
*   **翻訳サービスの利用**: DeepL翻訳APIを介して、高精度な機械翻訳機能を提供します。
*   **認証情報の管理**: `.env` ファイルからAPIキーなどの環境変数を自動的に読み込むことで、認証情報の安全な管理とコードからの分離を支援します。
*   **APIレスポンスの処理**: 各APIからのレスポンスから必要な情報（テキスト、JSON形式データ）を抽出するためのヘルパー関数を提供します。
*   **エラーハンドリング**: API呼び出し時の一般的なエラーや、APIキーの未設定といった問題を検知し、ユーザーに通知します。

このライブラリは、AIモデルを利用したアプリケーション開発において、異なるAPIサービスを柔軟に切り替えたり、共通のラッパーを通じて利用したりする際に役立ちます。

## 2) このライブラリを他のプログラムからimportする方法

`tkai_lib.py` ファイルがPythonのパス上にあるか、カレントディレクトリに配置されている場合、以下の方法でインポートできます。

```python
# ライブラリ全体をインポートし、tkai_lib.f_name() のように使用する
import tkai_lib

# 特定の関数のみをインポートし、f_name() のように直接使用する
from tkai_lib import read_ai_config, query_openai4, query_google
```

## 3) 必要な非標準ライブラリとインストール方法

このライブラリを使用するには、以下の非標準ライブラリが必要です。インポート時に不足しているライブラリについては、コンソールにインストールコマンドが表示されます。

| ライブラリ名             | インストールコマンド                       | 説明                                                                                |
| :----------------------- | :----------------------------------------- | :---------------------------------------------------------------------------------- |
| `python-dotenv`          | `pip install python-dotenv`                | `.env` ファイルから環境変数を読み込むために使用します。                             |
| `openai`                 | `pip install openai`                       | OpenAI API (GPT-4, GPT-5系) を利用するために使用します。                            |
| `google-generativeai`    | `pip install google-generativeai`          | Google Gemini API を利用するために使用します。                                      |
| `google-api-core`        | `pip install google-api-core`              | Google APIクライアントライブラリのコア部分。Google Geminiの例外処理などで使用します。 |
| `requests`               | `pip install requests`                     | HTTPリクエストを送信するために使用します（主にDeepL API用）。                      |

## 4) importできる変数と関数

### importできる変数

このライブラリには、外部から直接参照することを意図したグローバル変数は定義されていません。各APIクライアント（`openai`, `OpenAI`, `genai`, `requests`）はライブラリ内部で管理されており、対応するラッパー関数を通じて利用することが推奨されます。

### importできる関数

#### `read_ai_config(config_path: str = "translate.env", read_account_inf: bool = True)`

*   **動作**: 指定された設定ファイル（`.env`形式）から環境変数を読み込みます。APIキーなどの認証情報を設定するために使用されます。
*   **引数**:
    *   `config_path` (`str`, オプション): メインの設定ファイルへのパス。デフォルトは `"translate.env"` です。ファイルが存在しない場合、スクリプト実行ディレクトリからの相対パスも試行されます。
    *   `read_account_inf` (`bool`, オプション): `True` の場合、`config_path` から読み込んだ環境変数の中から `account_inf_path` を探し、そのパスにある `.env` ファイルも読み込みます。デフォルトは `True` です。
*   **戻り値**: なし

#### `openai_response_to_json(response)`

*   **動作**: OpenAI Chat Completions API (GPT-4系) のレスポンスオブジェクトから、メッセージコンテンツをJSON形式として評価し、その内容を抽出します。
*   **引数**:
    *   `response`: OpenAI APIからのレスポンスオブジェクト。`response.choices[0].message.content` にJSON形式の文字列が含まれていることを想定しています。
*   **戻り値**:
    *   `tuple`: `(最初のJSON要素, 全てのJSON要素を格納したリスト)`。JSONが単一のオブジェクトの場合は `(json_obj, [json_obj])`、リストやタプルの場合は `(list_or_tuple[0], list_or_tuple)` の形式で返します。

#### `extract_openai5_text(response) -> str | None`

*   **動作**: OpenAI Responses API (GPT-5系) のレスポンスオブジェクトから、出力テキストを手動で抽出します。`response.output_text` プロパティが利用できない場合に、`response.output` 配列をパースしてテキストを結合します。
*   **引数**:
    *   `response`: OpenAI Responses APIからのレスポンスオブジェクト。
*   **戻り値**:
    *   `str | None`: 抽出されたテキスト、またはテキストが見つからない場合は `None`。

#### `openai5_response_to_json(response)`

*   **動作**: OpenAI Responses API (GPT-5系) のレスポンスオブジェクトからテキストを抽出し、そのテキストをJSON形式として評価し、内容を抽出します。
*   **引数**:
    *   `response`: OpenAI Responses APIからのレスポンスオブジェクト。`extract_openai5_text` によってJSON形式の文字列が抽出されることを想定しています。
*   **戻り値**:
    *   `tuple`: `(最初のJSON要素, 全てのJSON要素を格納したリスト)`。`openai_response_to_json` と同様の形式。

#### `google_response_to_json(response)`

*   **動作**: Google Gemini API のレスポンスオブジェクトから、`response.text` プロパティに含まれるJSON形式の文字列を評価し、内容を抽出します。
*   **引数**:
    *   `response`: Google Gemini APIからのレスポンスオブジェクト。`response.text` にJSON形式の文字列が含まれていることを想定しています。
*   **戻り値**:
    *   `tuple`: `(最初のJSON要素, 全てのJSON要素を格納したリスト)`。`openai_response_to_json` と同様の形式。

#### `query_openai4(prompt, openai_model="gpt-4o", role=None, response_format=None, temperature=0.7, max_tokens=1000, openai_api_key=None)`

*   **動作**: OpenAI Chat Completions API (GPT-4系) を呼び出し、指定されたプロンプトに基づいてテキストを生成します。
*   **引数**:
    *   `prompt` (`str`): AIモデルへの入力プロンプト。
    *   `openai_model` (`str`, オプション): 使用するOpenAIモデルのID。デフォルトは `"gpt-4o"`。
    *   `role` (`str`, オプション): システムメッセージとして設定する役割（例: `"You are a helpful assistant."`）。指定しない場合はユーザープロンプトのみ。
    *   `response_format` (`dict`, オプション): レスポンスのフォーマットを指定する辞書（例: `{"type": "json_object"}`）。
    *   `temperature` (`float`, オプション): 生成されるテキストの多様性を制御する温度設定。0.0（決定的）から2.0（ランダム）まで。デフォルトは `0.7`。
    *   `max_tokens` (`int`, オプション): 生成される応答の最大トークン数。デフォルトは `1000`。
    *   `openai_api_key` (`str`, オプション): OpenAI APIキー。指定しない場合、環境変数 `OPENAI_API_KEY` から取得します。
*   **戻り値**:
    *   `object | False`: OpenAI APIからのレスポンスオブジェクト。APIキーが取得できない場合やAPI呼び出しに失敗した場合は `False` を返します。

#### `query_openai5(prompt, openai_model="gpt-5", instructions=None, role=None, effort="minimal", max_output_tokens=1024, store=False, response_format=None, openai_api_key=None)`

*   **動作**: OpenAI Responses API (GPT-5系) を呼び出し、指定されたプロンプトに基づいてテキストを生成します。GPT-5の新しい機能（`instructions`, `effort`など）に対応しています。
*   **引数**:
    *   `prompt` (`str` または `list`): AIモデルへの入力プロンプト。文字列またはResponses APIの入力オブジェクト配列で指定できます。
    *   `openai_model` (`str`, オプション): 使用するOpenAIモデルのID。デフォルトは `"gpt-5"`。
    *   `instructions` (`str`, オプション): システム相当の一括方針を指示する文字列。
    *   `role` (`str`, オプション): `prompt` が文字列の場合に、メッセージの役割（例: `"user"`, `"system"`）を指定します。
    *   `effort` (`str`, オプション): モデルの推論に費やす努力レベル（`"minimal"`, `"low"`, `"medium"`, `"high"`）。デフォルトは `"minimal"`。
    *   `max_output_tokens` (`int`, オプション): 生成される出力の最大トークン数。デフォルトは `1024`。
    *   `store` (`bool`, オプション): レスポンスをストレージに保存するかどうか。デフォルトは `False`。
    *   `response_format` (`dict`, オプション): レスポンスのフォーマットを指定する辞書（例: `{"type": "json_object"}`）。
    *   `openai_api_key` (`str`, オプション): OpenAI APIキー。指定しない場合、環境変数 `OPENAI_API_KEY` から取得します。
*   **戻り値**:
    *   `object | None`: OpenAI APIからのレスポンスオブジェクト。APIキーが取得できない場合やAPI呼び出しに失敗した場合は `None` を返します。出力テキストは `response.output_text` で取得できます。

#### `query_google(prompt, google_model="gemini-2.5-flash", role=None, generation_config=None, google_api_key=None)`

*   **動作**: Google Gemini API を呼び出し、指定されたプロンプトに基づいてテキストを生成します。
*   **引数**:
    *   `prompt` (`str`): AIモデルへの入力プロンプト。
    *   `google_model` (`str`, オプション): 使用するGoogle GeminiモデルのID。デフォルトは `"gemini-2.5-flash"`。
    *   `role` (`str`, オプション): システムメッセージとして設定する役割。指定する場合、プロンプトはメッセージリスト形式で送られます。
    *   `generation_config` (`dict`, オプション): 生成パラメータを設定する辞書（例: `{"response_mime_type": "application/json"}`）。
    *   `google_api_key` (`str`, オプション): Google APIキー。指定しない場合、環境変数 `GOOGLE_API_KEY` から取得します。
*   **戻り値**:
    *   `object | False`: Google Gemini APIからのレスポンスオブジェクト。APIキーが取得できない場合やAPI呼び出しに失敗した場合は `False` を返します。

#### `query_google2(messages, google_model="gemini-2.5-flash", generation_config=None, safety_settings=None, google_api_key=None)`

*   **動作**: Google Gemini API を呼び出し、チャット履歴の形式（メッセージリスト）でプロンプトを送信し、テキストを生成します。デフォルトの生成設定と安全性設定が含まれています。
*   **引数**:
    *   `messages` (`list`): チャット履歴を表すメッセージオブジェクトのリスト。各オブジェクトは `{"role": "user", "parts": [prompt_text]}` のような形式です。
    *   `google_model` (`str`, オプション): 使用するGoogle GeminiモデルのID。デフォルトは `"gemini-2.5-flash"`。
    *   `generation_config` (`dict`, オプション): 生成パラメータを設定する辞書。指定しない場合、デフォルト値（`temperature=0.7`, `top_p=0.8`, `top_k=40`, `max_output_tokens=1500`など）が適用されます。
    *   `safety_settings` (`list`, オプション): コンテンツの安全性設定のリスト。指定しない場合、デフォルト値（中程度のハラスメントなどをブロック）が適用されます。
    *   `google_api_key` (`str`, オプション): Google APIキー。指定しない場合、環境変数 `GOOGLE_API_KEY` から取得します。
*   **戻り値**:
    *   `object | None`: Google Gemini APIからのレスポンスオブジェクト。APIキーが取得できない場合、API呼び出しに失敗した場合、またはプロンプトがブロックされた場合は `None` を返します。

#### `extract_deepl_text(response) -> str | None`

*   **動作**: DeepL APIのレスポンスオブジェクトから、翻訳されたテキストを抽出します。
*   **引数**:
    *   `response`: `requests` ライブラリのレスポンスオブジェクト。DeepL APIからの正常な応答（ステータスコード200）を想定しています。
*   **戻り値**:
    *   `str | None`: 翻訳されたテキスト、またはエラーが発生した場合は `None`。

#### `query_deepl(text, source_lang="JA", target_lang="EN", deepl_api_key=None, endpoint="free")`

*   **動作**: DeepL翻訳APIを呼び出し、指定されたテキストを翻訳します。
*   **引数**:
    *   `text` (`str`): 翻訳する元のテキスト。
    *   `source_lang` (`str`, オプション): 元のテキストの言語コード（例: `"JA"`, `"EN"`）。デフォルトは `"JA"`。
    *   `target_lang` (`str`, オプション): 翻訳先の言語コード（例: `"EN"`, `"JA"`）。デフォルトは `"EN"`。
    *   `deepl_api_key` (`str`, オプション): DeepL APIキー。指定しない場合、環境変数 `DEEPL_API_KEY` から取得します。
    *   `endpoint` (`str`, オプション): DeepL APIのエンドポイント。"free" (無料版) または "pro" (有料版) を指定。デフォルトは `"free"`。
*   **戻り値**:
    *   `object | None | False`: `requests` ライブラリのレスポンスオブジェクト。APIキーが取得できない場合やAPI呼び出しに失敗した場合は `None` または `False` を返します。

#### `query(prompt: str, api: str, api_key: str, model: str)`

*   **動作**: 汎用的なAIクエリ関数で、指定されたAPIタイプとモデルに基づいてAIモデルを呼び出し、テキストを生成します。
*   **引数**:
    *   `prompt` (`str`): AIモデルへの入力プロンプト。
    *   `api` (`str`): 使用するAPIのタイプを指定する文字列。以下のいずれかを指定します。
        *   `"gemini"` または `"google"`: Google Gemini APIを呼び出します。
        *   `"openai5"`: OpenAI Responses API (GPT-5系) を呼び出します。
        *   `"openai"`: OpenAI Chat Completions API (GPT-4系) を呼び出します。
    *   `api_key` (`str`): 各APIに対応するAPIキー。
    *   `model` (`str`): 使用するAIモデルのID（例: `"gpt-4o"`, `"gemini-1.5-pro"`）。
*   **戻り値**:
    *   `tuple`: `(生成されたテキスト, APIからのレスポンスオブジェクト)`。API呼び出しに失敗した場合は `(None, None)` を返します。

## 5) main scriptとして実行したときの動作

`tkai_lib.py` には `if __name__ == "__main__":` ブロックが存在しないため、このファイルを直接実行しても特定の動作は行いません。ライブラリとして他のPythonスクリプトからインポートして使用することを想定しています。

---