以下に、`schottky.py` プログラムのマニュアルを生成します。

---

# schottky.py マニュアル

## プログラムの目的

`schottky.py` は、ショットキー障壁ダイオードの電流-電圧 (I-V) 特性をシミュレーションし、その結果をプロットするPythonプログラムです。熱電子放出、拡散、ショットキー障壁低下、電子トンネリング、熱電子電界放出 (TFE) といった複数の物理モデルをサポートしています。これにより、ユーザーはデバイスの温度、材料定数、幾何学的パラメータなどを変更して、それぞれのモデルがI-V特性に与える影響を比較検討できます。

## 原理

`schottky.py` は、以下の主要な物理定数を使用してショットキーダイオードの動作をモデル化します。

-   **ボルツマン定数** ($$ k_B = 1.380649 \times 10^{-23} \text{ J/K} $$)
-   **素電荷** ($$ q = 1.60217663 \times 10^{-19} \text{ C} $$)
-   **真空の誘電率** ($$ \epsilon_0 = 8.854187 \times 10^{-12} \text{ F/m} $$)
-   **電子質量** ($$ m_e = 9.109383 \times 10^{-31} \text{ kg} $$)
-   **ディラック定数** ($$ \hbar = 1.0545718 \times 10^{-34} \text{ Js} $$)

### 1. 基本パラメータの計算 (`calculate_params`関数)

プログラムはまず、以下のデバイスおよび材料に関する基本パラメータを計算します。

-   **リチャードソン定数 ($$ A^* $$)**
    半導体中の電子の有効質量比 ($$ m_{en} $$) に基づいて計算される、修正されたリチャードソン定数です。
    $$ A^* = 1.20173 \times 10^6 \times m_{en} \quad [\text{A/m}^2/\text{K}^2] $$

-   **伝導帯の有効状態密度 ($$ N_C $$)**
    半導体内の伝導帯における有効状態密度。温度 ($$ T $$) および電子の有効質量比 ($$ m_{en} $$) に依存します。
    $$ N_C = 2.51 \times 10^{19} \times (m_{en})^{1.5} \times \left(\frac{T}{300}\right)^{1.5} \quad [\text{cm}^{-3}] $$

-   **半導体のフェルミ準位 ($$ E_{fn} $$)**
    半導体側の伝導帯端 ($$ E_{cn} $$、電子親和力に相当)、ドナー濃度 ($$ N_D $$)、および有効状態密度 ($$ N_C $$) から決定されます。
    $$ E_{fn} = E_{cn} - \frac{k_B T}{q} \ln\left(\frac{N_D}{N_C}\right) $$

-   **ショットキー障壁高さ ($$ \phi_B $$)**
    金属の仕事関数 ($$ E_{fm} $$) と半導体の電子親和力 ($$ E_{cn} $$) から理想的なショットキー障壁高さが計算されます。
    $$ \phi_B = E_{fm} - E_{cn} $$

-   **内蔵電位 ($$ V_{bi} $$)**
    金属と半導体間の熱平衡状態におけるフェルミ準位の差から内蔵電位が計算されます。
    $$ V_{bi} = E_{fm} - E_{fn} $$

-   **理想飽和電流密度 ($$ J_s $$)**
    リチャードソン・ダッシュマンの式に基づき、温度 ($$ T $$) とショットキー障壁高さ ($$ \phi_B $$) から理想的な飽和電流密度が計算されます。
    $$ J_s = A^* T^2 \exp\left(-\frac{q \phi_B}{k_B T}\right) $$

-   **半導体の直列抵抗 ($$ R_s $$)**
    半導体の電気伝導度 ($$ \sigma_n $$) と厚さ ($$ D_n $$)、デバイス面積 ($$ Area $$) から直列抵抗が計算されます。
    $$ \sigma_n = q N_D \mu_n $$
    $$ R_s = \frac{D_n}{\sigma_n \times Area} $$
    ここで $$ \mu_n $$ は電子移動度です。

### 2. ショットキー電流の計算 (`calculate_schottky_current`関数)

印加電圧 ($$ V_{app} $$) に対するダイオード電圧 ($$ V_D $$) および電流 ($$ I $$) は、以下の方程式をニュートン法に似た反復計算で解くことで求められます。
$$ V_{app} = V_D + I(V_D) R_s $$
ここで $$ I(V_D) $$ は選択された物理モデルに基づいたダイオード電流です。

各物理モデルにおける電流の式は以下の通りです。

-   **`Simple` モデル (理想ダイオードモデル)**
    最も基本的なモデルで、熱電子放出のみを考慮します。理想因子 ($$ n $$) はプログラム中で1.0に固定されています。
    $$ I = J_s \left( \exp\left(\frac{V_D}{n k_B T / q}\right) - 1 \right) \times Area $$

-   **`Diffusion` モデル (拡散モデル)**
    半導体中の少数キャリア拡散が電流を支配すると仮定するモデルです。
    $$ E_{max} = \sqrt{\frac{2q N_D (V_{bi} - V_D)}{\epsilon_s}} $$
    $$ I = q \mu_s N_C E_{max} \exp\left(-\frac{q \phi_B}{k_B T}\right) \left( \exp\left(\frac{V_D}{n k_B T / q}\right) - 1 \right) \times Area $$
    ここで $$ \epsilon_s = \epsilon_r \epsilon_0 $$ は半導体の誘電率です。

-   **`Schottky` モデル (ショットキー障壁低下モデル)**
    高電界下でのイメージ力によるショットキー障壁低下を考慮したモデルです。障壁低下量 ($$ \Delta \phi_B^{eff} $$) の近似として、以下の項が使用されます。
    $$ k_1 = \left(\frac{q}{\epsilon_s}\right)^{1.5} \frac{\sqrt{2}}{4\pi} \sqrt{N_D} \sqrt{V_{bi} - V_D} $$
    $$ I = J_s \exp\left(\frac{q}{k_B T} \sqrt{k_1}\right) \left( \exp\left(\frac{V_D}{n k_B T / q}\right) - 1 \right) \times Area $$

-   **`Tunneling` モデル (簡易トンネルモデル)**
    電子のトンネリング効果を簡易的に考慮したモデルです。逆方向バイアスや高ドーピング濃度で顕著になります。
    $$ I = J_s \exp\left(\frac{V_D}{n_{tunnel} \times 0.026}\right) \left( \exp\left(\frac{V_D}{n k_B T / q}\right) - 1 \right) \times Area $$
    ここで $$ n_{tunnel} $$ はトンネリング理想因子であり、$$ 0.026 \text{ V} $$ は室温 ($$ 300 \text{ K} $$) での熱電圧 ($$ k_B T / q $$) の近似値です。

-   **`TFE` モデル (熱電子電界放出モデル)**
    熱電子放出 (Thermionic Emission) と電界放出 (Field Emission) の両方を考慮するモデルです。高ドーピングや低温で重要になります。
    $$ E_{00} = \frac{q \hbar}{2} \sqrt{\frac{N_D}{\epsilon_s m_{eff}}} $$
    ここで $$ m_{eff} = m_{en} m_e $$ は電子の有効質量です。
    $$ E_0 = E_{00} \left( \frac{1}{\tanh(E_{00} / (k_B T / q))} \right) $$

    **順方向 ($$ V_D \ge 0 $$):**
    $$ I = J_s \left( \exp\left(\frac{V_D}{E_0}\right) - 1 \right) \times Area $$

    **逆方向 ($$ V_D < 0 $$):**
    逆方向バイアスでは、電界による障壁の薄層化を考慮し、トンネル透過率が増加します。
    $$ E_{max} = \sqrt{\frac{2q N_D (V_{bi} - V_D)}{\epsilon_s}} $$
    $$ \text{tunnel_factor} = \exp\left(|V_D| \left(\frac{E_{00}}{k_B T / q}\right)^2\right) $$
    $$ I = J_s \times \text{tunnel_factor} \times \left( \exp\left(\frac{V_D}{E_0}\right) - 1 \right) \times Area $$

## 使い方 (usage)

プログラムはコマンドライン引数を受け付けて動作します。`schottky.py` を実行するには、以下のコマンド形式を使用します。

```bash
python schottky.py [オプション]
```

利用可能なオプションは以下の通りです。

| オプション       | 型     | デフォルト値 | 説明                                       |
| :--------------- | :----- | :----------- | :----------------------------------------- |
| `--model`        | string | `Simple`     | 使用する物理モデルを選択します。`Simple`, `Diffusion`, `Schottky`, `Tunneling`, `TFE` から選択。 |
| `--temp`         | float  | `300.0`      | 温度 [K]                                   |
| `--area`         | float  | `0.01`       | デバイス面積 [cm^2]                        |
| `--efm`          | float  | `4.4`        | 金属のフェルミ準位 (仕事関数) [eV]         |
| `--ecn`          | float  | `4.05`       | 半導体の電子親和力 [eV]                    |
| `--ndn`          | float  | `1.0e16`     | 半導体のドナー濃度 [cm^-3]                 |
| `--mun`          | float  | `1500.0`     | 半導体の電子移動度 [cm^2/Vs]               |
| `--eps_r`        | float  | `11.9`       | 半導体の比誘電率                           |
| `--dn`           | float  | `1000.0`     | 半導体の厚さ [nm]                          |
| `--men`          | float  | `0.19`       | 半導体の電子有効質量比 ($$ m^*/m_e $$)    |
| `--n_tunnel`     | float  | `2.0`        | `Tunneling` モデルにおけるトンネリング理想因子 |
| `--v0`           | float  | `-2.0`       | 印加電圧の開始点 [V]                       |
| `--v1`           | float  | `1.0`        | 印加電圧の終了点 [V]                       |
| `--step`         | float  | `0.02`       | 電圧ステップ [V]                           |

## 使用例

### 1. デフォルト設定でシミュレーションを実行

最も基本的な使用法です。`Simple` モデルが選択され、デフォルトのパラメータが使用されます。

```bash
python schottky.py
```

このコマンドを実行すると、デフォルトパラメータでのショットキーダイオードのI-V特性がプロットされ、コンソールには計算された基本パラメータが表示されます。

### 2. `TFE` モデルと異なるドナー濃度でシミュレーションを実行

半導体ドナー濃度を高く設定し、`TFE` モデルを用いてI-V特性をシミュレーションします。

```bash
python schottky.py --model TFE --ndn 1.0e18 --v0 -5.0
```

この例では、`TFE` モデルを選択し、ドナー濃度を `1.0e18 cm^-3` に変更しています。また、逆方向電圧範囲を `-5.0 V` まで広げています。高濃度ドナーでは電界放出効果が顕著になるため、`TFE` モデルがより適切です。

### 3. 特定の温度とデバイス面積でシミュレーションを実行

低温での特性や、デバイスサイズの影響を調べる場合に使用します。

```bash
python schottky.py --temp 77.0 --area 0.001 --model Diffusion
```

この例では、温度を `77.0 K` に、デバイス面積を `0.001 cm^2` に変更し、`Diffusion` モデルを使用しています。

---