以下は、pnjunction.pyプログラムのマニュアルです。pandocでWord/PowerPointに変換できるように、数式はLaTeXのブロック形式で記述されています。

---

# pnjunction.py プログラムマニュアル

## プログラム名
`pnjunction.py`

## プログラムの目的
`pnjunction.py` は、PN接合ダイオードの電流-電圧（IV）特性をシミュレーションし、その結果をプロットするPythonスクリプトです。材料の物理パラメータ（ドーピング濃度、有効質量、移動度、キャリア寿命など）と環境温度を考慮に入れ、理想ダイオードモデルに直列抵抗を加えた特性を計算します。これにより、PN接合デバイスの基本的な電気的挙動を理解し、設計パラメータがデバイス性能に与える影響を評価するためのツールとして機能します。

## 原理

このプログラムは、PN接合ダイオードの基本的な半導体物理学に基づいて電流-電圧特性を計算します。

### 1. 物理定数

以下の物理定数が使用されます。

*   **ボルツマン定数** ($k_B$):
    $$
    k_B = 1.380649 \times 10^{-23} \text{ J/K}
    $$
*   **素電荷** ($q$):
    $$
    q = 1.60217663 \times 10^{-19} \text{ C}
    $$

### 2. 材料パラメータの計算 (`calculate_material_params` 関数)

この関数は、与えられた温度と材料パラメータからPN接合の基本的な特性値を計算します。

*   **有効状態密度** ($N_c$, $N_v$):
    伝導帯 ($N_c$) および価電子帯 ($N_v$) の有効状態密度は、温度 ($T$) と電子・正孔の有効質量比 ($m_e^*/m_0$, $m_h^*/m_0$) に依存します。
    $$
    N_c = 2.51 \times 10^{19} \left(\frac{m_e^*}{m_0}\right)^{1.5} \left(\frac{T}{300}\right)^{1.5} \text{ cm}^{-3}
    $$
    $$
    N_v = 2.51 \times 10^{19} \left(\frac{m_h^*}{m_0}\right)^{1.5} \left(\frac{T}{300}\right)^{1.5} \text{ cm}^{-3}
    $$
    ここで、$m_0$ は自由電子質量です。

*   **フェルミ準位** ($E_{Fn}$, $E_{Fp}$):
    n型半導体とp型半導体それぞれのフェルミ準位 ($E_{Fn}$, $E_{Fp}$) は、ドーピング濃度 ($N_D$, $N_A$)、有効状態密度、伝導帯端 ($E_c$) および価電子帯端 ($E_v$) エネルギーから計算されます。
    $$
    E_{Fn} = E_{c,n} - \frac{k_B T}{q} \ln\left(\frac{N_D}{N_c}\right)
    $$
    $$
    E_{Fp} = E_{v,p} + \frac{k_B T}{q} \ln\left(\frac{N_A}{N_v}\right)
    $$

*   **ビルトイン電位** ($V_{bi}$):
    PN接合内部に存在する電位障壁（ビルトイン電位）は、平衡状態でのp型とn型のフェルミ準位の差に等しくなります。
    $$
    V_{bi} = E_{Fp} - E_{Fn}
    $$

*   **拡散係数** ($D_n$, $D_p$):
    電子 ($D_n$) および正孔 ($D_p$) の拡散係数は、アインシュタインの関係式を用いて移動度 ($\mu_n$, $\mu_p$) から導出されます。
    $$
    D_n = \mu_n \frac{k_B T}{q}
    $$
    $$
    D_p = \mu_p \frac{k_B T}{q}
    $$

*   **拡散長** ($L_n$, $L_p$):
    電子 ($L_n$) および正孔 ($L_p$) の拡散長は、拡散係数とキャリア寿命 ($\tau_n$, $\tau_p$) から計算されます。
    $$
    L_n = \sqrt{D_n \tau_n}
    $$
    $$
    L_p = \sqrt{D_p \tau_p}
    $$

*   **飽和電流密度** ($J_s$):
    理想ダイオードの飽和電流密度は、少数キャリアの拡散と再結合によって決定されます。プログラムでは、以下の式を用いて計算されます。
    $$
    J_s = q \left( \frac{D_n}{L_n} N_D \exp\left(-\frac{q V_{bi}}{k_B T}\right) + \frac{D_p}{L_p} N_A \exp\left(-\frac{q V_{bi}}{k_B T}\right) \right)
    $$
    この式は、少数キャリア濃度を $n_{p0} = N_D \exp(-q V_{bi}/(k_B T))$ および $p_{n0} = N_A \exp(-q V_{bi}/(k_B T))$ とした場合の一般的な飽和電流密度 ($J_s = q (D_n/L_n \cdot n_{p0} + D_p/L_p \cdot p_{n0})$) に対応します。

### 3. ダイオード電流の計算 (`calculate_diode_current` 関数)

この関数は、特定の印加電圧 ($V_{target}$) におけるダイオードの電流を計算します。

*   **熱電圧** ($V_T$):
    $$
    V_T = \frac{n \cdot k_B T}{q}
    $$
    ここで $n$ は理想係数であり、このプログラムでは1.0として扱われます。

*   **ショックレーのダイオード方程式**:
    理想的なPN接合ダイオードの電流 ($I_D$) は、ダイオードにかかる電圧 ($V_D$) に対して指数関数的に変化します。
    $$
    I_D = I_s \left( \exp\left(\frac{V_D}{V_T}\right) - 1 \right) \cdot \text{Area}
    $$
    ここで $I_s = J_s \cdot \text{Area}$ は飽和電流です。

*   **直列抵抗の影響**:
    実際のダイオードでは、内部抵抗や配線抵抗などにより直列抵抗 ($R_s$) が存在します。これにより、ダイオードに印加される外部電圧 ($V_{app}$) とダイオード両端の電圧 ($V_D$) の間に以下の関係が成り立ちます。
    $$
    V_{app} = V_D + I_D R_s
    $$
    この方程式は非線形であり、$V_{app}$ が与えられたときに $V_D$ (および $I_D$) を直接解くことはできません。プログラムでは、**ニュートン法**を用いて数値的に $V_D$ を反復計算で求めます。

    ニュートン法の基本的な考え方は、$f(V_D) = V_D + I_D(V_D) R_s - V_{app} = 0$ という方程式の根を見つけることです。各ステップで、$V_D$ の更新は以下の式で行われます。
    $$
    V_{D, \text{new}} = V_{D, \text{old}} - \frac{f(V_{D, \text{old}})}{f'(V_{D, \text{old}})}
    $$
    ここで $f'(V_D)$ は $f(V_D)$ の $V_D$ に関する微分です。プログラムでは、数値微分を用いて $f'(V_D)$ を近似しています。

### 4. IV特性の生成とプロット (`main` 関数)

`main` 関数は、ユーザー指定の電圧範囲とステップで、`calculate_diode_current` 関数を繰り返し呼び出し、各印加電圧における電流値を計算します。最終的に、印加電圧と電流の関係（IV特性）をセミログスケールでプロットします。

## 使い方 (Usage)

コマンドラインから `pnjunction.py` を実行します。様々なシミュレーションパラメータをコマンドライン引数で指定できます。

```bash
python pnjunction.py [OPTIONS]
```

### オプション

| オプション       | 型    | デフォルト値 | 説明                                        |
| :--------------- | :---- | :----------- | :------------------------------------------ |
| `--temp`         | float | `300.0`      | 温度 [K]                                    |
| `--area`         | float | `0.01`       | 接合面積 [cm$^2$]                           |
| `--rs`           | float | `10.0`       | 直列抵抗 [Ω]                                 |
| `--ndn`          | float | `1.0e16`     | n型ドーピング濃度 [cm$^{-3}$]                |
| `--ecn`          | float | `4.05`       | n型伝導帯端エネルギー [eV]                  |
| `--men`          | float | `0.19`       | n型電子有効質量比 ($m_e^*/m_0$)             |
| `--mun`          | float | `1500.0`     | n型電子移動度 [cm$^2$/(V$\cdot$s)]           |
| `--taun`         | float | `1e-5`       | n型電子寿命 [s]                             |
| `--nap`          | float | `1.0e16`     | p型ドーピング濃度 [cm$^{-3}$]                |
| `--evp`          | float | `5.17`       | p型価電子帯端エネルギー [eV]                |
| `--mhp`          | float | `0.16`       | p型正孔有効質量比 ($m_h^*/m_0$)             |
| `--mup`          | float | `500.0`      | p型正孔移動度 [cm$^2$/(V$\cdot$s)]           |
| `--taup`         | float | `1e-5`       | p型正孔寿命 [s]                             |
| `--v0`           | float | `-1.0`       | 印加電圧の開始値 [V]                        |
| `--v1`           | float | `1.0`        | 印加電圧の終了値 [V]                        |
| `--step`         | float | `0.02`       | 印加電圧のステップサイズ [V]                |
| `--noplot`       | action | `False`     | プロット表示を無効にする (設定すると表示しない)|

## 使用例

### 1. 基本的なPN接合のIV特性プロット

デフォルトパラメータでPN接合のIV特性を計算し、プロットを表示します。

```bash
python pnjunction.py
```

これにより、デフォルトのパラメータ（温度300K、直列抵抗10Ωなど）でのPN接合ダイオードの電流-電圧特性グラフが表示されます。コンソールには計算されたビルトイン電位 ($V_{bi}$) と飽和電流密度 ($J_s$) も出力されます。

```
Calculated Vbi: 0.7024 V
Calculated Js : 2.503610e-11 A/cm2
```
(出力される数値は実行環境によって小数点以下の桁数が異なる場合があります。)

### 2. 直列抵抗を変更してプロット

直列抵抗を `1.0` オームに設定して、その影響を確認します。

```bash
python pnjunction.py --rs 1.0
```

これにより、直列抵抗が低い場合のIV特性がプロットされます。通常、順方向バイアスでの電圧降下が小さくなり、より急峻な立ち上がりを示すでしょう。

### 3. 温度を上げてIV特性をプロット

温度を `400` ケルビンに上げてシミュレーションします。

```bash
python pnjunction.py --temp 400.0
```

温度が上がると、熱電圧 ($V_T$) が増加し、飽和電流 ($I_s$) も大きく増加するため、IV特性が変化します。順方向電圧の立ち上がりも低温時と比較して低い電圧から始まる傾向があります。

### 4. プロットを表示せずに計算結果のみを確認

プロット表示を無効にし、計算されたビルトイン電位と飽和電流密度のみをコンソールに出力します。

```bash
python pnjunction.py --noplot
```

このコマンドはグラフウィンドウを表示せず、コンソールに以下の出力のみを行います。

```
Calculated Vbi: 0.7024 V
Calculated Js : 2.503610e-11 A/cm2
```
(出力される数値は実行環境によって小数点以下の桁数が異なる場合があります。)

### 5. ドーピング濃度と有効質量を変更した例

n型とp型のドーピング濃度を `1e17` に、電子の有効質量比を `0.07` に変更します。

```bash
python pnjunction.py --ndn 1.0e17 --nap 1.0e17 --men 0.07
```

このように、さまざまなパラメータを変更して、PN接合ダイオードの性能がどのように変化するかを分析することができます。