# mu_fit.py マニュアル

## プログラムの目的
mu_fit.py は、Hall 効果測定などから得られた **移動度 μ の温度依存データ**を、複数の散乱機構モデルに基づいてフィッティングするための解析プログラムです。  
単なる最適化にとどまらず、

- 指定した温度範囲のみを用いたフィッティング
- パラメータ誤差（共分散行列）評価
- 誤差伝播によるモデル予測誤差帯の推定
- パラメータ間相関・縮退方向の診断
- 「数値的に固定を検討すべきパラメータ」の提案

までを一貫して行うことを目的としています。

研究用途（論文・報告書）で「どこまで決まっていて、どこが決まっていないか」を可視化することを強く意識した設計になっています。

---

## 原理

### 移動度モデル
全移動度 μ は、散乱率の加算則に基づき

$$
\frac{1}{\mu(T)} = \left( \frac{1}{\mu_{\mathrm{op}}}
+ \frac{1}{\mu_{\mathrm{ac}}}
+ \frac{1}{\mu_{\mathrm{ni}}}
+ \frac{1}{\mu_{\mathrm{ii}}} \right)
\exp\!\left(\frac{V_B}{k_B T}\right)
$$

で表されます。

各項は以下の温度依存性を持ちます。

- 光学フォノン散乱  
$$
\mu_{\mathrm{op}}^{-1} \propto a_{\mathrm{op}}
\left[\exp\!\left(\frac{E_{\mathrm{op}}}{k_B T}\right)-1\right]^{-1}
$$

- 音響フォノン散乱  
$$
\mu_{\mathrm{ac}}^{-1} \propto a_1 T^{3/2}
$$

- 中性不純物散乱  
$$
\mu_{\mathrm{ni}}^{-1} \propto a_2
$$

- イオン化不純物散乱  
$$
\mu_{\mathrm{ii}}^{-1} \propto a_3 T^{-3/2}
$$

ここでフィッティングパラメータは  
(aop, a1, a2, a3, VB) の 5 つです。

---

### フィッティング方法
観測値 μ_exp とモデル μ_model の差を **対数空間**で定義します。

$$
r_i = \log_{10}\mu_{\mathrm{exp}}(T_i)
     - \log_{10}\mu_{\mathrm{model}}(T_i)
$$

目的関数は

$$
S = \sum_i r_i^2
$$

で、scipy.optimize.minimize により最小化されます。

---

### パラメータ誤差・相関評価
最適解近傍で線形化を行い、残差のヤコビアン J を用いて

$$
\mathrm{Cov}(\theta)
\approx s^2 (J^\mathrm{T} J)^{-1}
$$

を評価します。ここで

$$
s^2 = \frac{1}{N-M}\sum_i r_i^2
$$

です。

- 共分散行列 Cov  
- 相関係数行列 Corr  
- 固有値・固有ベクトル（不確かさの主成分）  
- JᵀJ の固有値（悪条件方向）

をすべて出力します。

---

### 誤差伝播（予測誤差帯）
モデル予測値 y(T)=log10 μ(T) に対して、デルタ法により

$$
\mathrm{Var}[y(T)] = \nabla y^\mathrm{T}\, \mathrm{Cov}\, \nabla y
$$

を評価し、±nσ の誤差帯を計算します。  
グラフ上では **薄水色の帯**として表示されます。

---

### 固定パラメータ提案ロジック
以下を総合したヒューリスティックにより候補を提示します。

1. 相対誤差が大きい（stderr / |value|）
2. 他パラメータとの強い相関（|ρ| ≥ 0.95）
3. 共分散最大固有値方向（最も不確かな主成分）への寄与が大きい

これは「物理的に正しい固定」を保証するものではなく、  
**数値的に決まりにくい方向**を示す診断結果です。

---

## 使い方 (usage)

### 基本形式
python mu_fit.py --mode fit --input データファイル.xlsx

### 主なオプション
- --mode  
  read : データ確認  
  llsq : 線形最小二乗による初期値推定  
  fit  : 非線形フィッティング＋誤差解析  
  weight : 散乱機構寄与率の可視化  

- --fix  
  固定するパラメータ名をカンマ区切りで指定  
  例: a2,VB

- --Tfitmin, --Tfitmax  
  フィッティングに使用する温度範囲 [K]  
  デフォルト: -1e100, +1e100（全範囲）

- --band_sigma  
  誤差帯の幅（nσ, デフォルト 1.0）

- --eop  
  光学フォノンエネルギー [eV]

---

## 使用例

### 1. 全温度範囲でフィット
python mu_fit.py --mode fit --input Hall-T1.xlsx --eop 0.045

### 2. 150–450 K のみでフィット
python mu_fit.py --mode fit --input Hall-T1.xlsx --Tfitmin 150 --Tfitmax 450

### 3. a2 と VB を固定してフィット
python mu_fit.py --mode fit --input Hall-T1.xlsx --fix a2,VB

---

## 出力ファイル一覧
- fit_params.json  
  最適化されたパラメータ

- fit_params_with_errors.json  
  パラメータ値と標準誤差

- fit_diagnostics_opt.json  
  共分散行列・相関係数・固有値・条件数

- fit_fix_suggestions.json  
  固定候補パラメータの提案（理由付き）

- mu_vs_T_fit.png  
  フィット結果＋誤差帯プロット

---

## 注意事項
- 共分散解析は局所線形近似に基づきます。
- 強い非線形性やデータ不足の場合、誤差や相関は不安定になります。
- 固定パラメータの最終判断は、文献値・独立測定・物理的妥当性を必ず考慮してください。

本プログラムは「よくフィットするか」だけでなく  
**「どこまで信じてよいか」**を判断するための解析ツールです。
