# Ne-T_fit.py マニュアル

## 1. プログラムの目的

Ne-T_fit.py は、半導体のキャリア統計（フェルミ準位 Ef、電子濃度 n=Ne、正孔濃度 p、ドナー/アクセプターのイオン化率）を、フェルミ・ディラック積分（オーダー 1/2）を用いて計算し、さらに実験データ Ne(T) に対してパラメータフィッティングを行うプログラムです。

主な用途は以下です。

- **計算（sim）**：与えた物理パラメータ（Eg, ED, EA, ND, NA, me, mh）から Ne(T) を計算しプロットする  
- **読み込み表示（read）**：入力データ（Ne(T)）を表示・プロットする  
- **フィッティング（fit）**：観測データ Ne(T) から、ED, ND, EA, NA, Eg を最適化して推定する  
- **誤差解析（fit 内）**：ヤコビアンによる線形化近似で共分散・相関・固有値/固有ベクトルを出力し、さらに誤差伝播で Ne(T) の推定誤差帯（薄色）をプロットする  
- **固定パラメータ提案（fit 内）**：大きい誤差・強相関・不確か方向への寄与を基準に、固定（または外部拘束）候補を推定する  

---

## 2. 原理

### 2.1 半導体キャリア統計（基本式）

温度 T における伝導帯端 Ec、価電子帯端 Ev のもとで、電子・正孔密度はフェルミ・ディラック積分（オーダー 1/2）で計算します。

有効状態密度（cm^-3）は、

$$
N_c(T) = 2\left(\frac{m_e^\* m_0 kT}{2\pi\hbar^2}\right)^{3/2}\times 10^{-6},
\qquad
N_v(T) = 2\left(\frac{m_h^\* m_0 kT}{2\pi\hbar^2}\right)^{3/2}\times 10^{-6}
$$

ここで $m_0$ は電子質量、$m_e^\*, m_h^\*$ は有効質量比です。

フェルミ準位 Ef に対して、電子濃度 Ne と正孔濃度 Nh は

$$
n = N_c \frac{2}{\sqrt{\pi}} F_{1/2}\!\left(\frac{E_f-E_c}{k_BT}\right), 
\qquad
p = N_v \frac{2}{\sqrt{\pi}} F_{1/2}\!\left(\frac{E_v-E_f}{k_BT}\right)
$$

を用います（$k_B T$ は eV 単位に変換して使用）。

本プログラムでは、積分の安定性のため

- $f(x)=1/(1+\exp(x-\eta))$ を `expit` で評価
- $F_{1/2}$ を数値積分 `quad` で計算（0〜500 を既定）

としています。

---

### 2.2 不純物のイオン化（ドナー ND+, アクセプター NA-）

ドナー準位を $E_D = E_c - ED$ とし、ドナーの中性占有率は

$$
f_D = \frac{1}{1+g_D\exp\left(\frac{E_D-E_f}{k_BT}\right)}
$$

よってイオン化ドナーは

$$
N_D^+ = N_D(1-f_D)
$$

アクセプター準位を $E_A = E_v + EA$ とし、アクセプターのイオン化率（占有率）は

$$
f_A = \frac{1}{1+g_A\exp\left(\frac{E_A-E_f}{k_BT}\right)}
$$

よってイオン化アクセプターは

$$
N_A^- = N_A f_A
$$

ここでも `expit` を用いて数値的安定性を確保します。

---

### 2.3 電荷中性条件と Ef の決定

フェルミ準位 Ef は電荷中性条件

$$
p - n + N_D^+ - N_A^- = 0
$$

を満たす解として求めます。  
本プログラムでは `brentq` による 1 次元根探索を使用し、解が見つからない場合は探索区間を自動拡張します。

---

### 2.4 フィッティング（mode=fit）

観測データ $(T_i, N_{e,i}^{obs})$ に対し、モデル $N_e^{model}(T_i;\theta)$ の **log10 残差**を定義します。

$$
r_i(\theta) = \log_{10} N_{e,i}^{model} - \log_{10} N_{e,i}^{obs}
$$

目的関数（最小化）は

$$
RSS(\theta)=\sum_i r_i(\theta)^2
$$

です。最適化には `scipy.optimize.minimize` を用い、既定は Nelder–Mead です。

また ND, NA は桁が大きい量のため、最適化では内部的に

- ND, NA を **log10 空間**で最適化
- ED, EA, Eg は線形空間で最適化

とします。

---

### 2.5 共分散行列・相関行列（線形化近似）

最適解 $\hat{\theta}$ 近傍で残差ベクトルを線形化し、ヤコビアン

$$
J_{ij}=\frac{\partial r_i}{\partial \theta_j}
$$

を数値微分で求めます。  
このとき、内部パラメータの共分散は

$$
\mathrm{Cov}(\theta) \approx s^2 (J^T J)^{-1},
\qquad
s^2=\frac{RSS}{N-M}
$$

（$N$: フィットに使った点数、$M$: 自由パラメータ数）で近似します。

相関係数行列は

$$
\mathrm{Corr}_{ij} = \frac{\mathrm{Cov}_{ij}}{\sigma_i\sigma_j}
$$

で計算します。

---

### 2.6 固有値・固有ベクトル解析

- Cov の固有分解：不確かさ（分散）が大きい方向の線形結合を抽出  
- $J^T J$ の固有分解：小さい固有値の方向は「データが決めにくい方向」  

ここで

- Cov の大きい固有値 → 不確かさが大きい主方向  
- $J^T J$ の小さい固有値 → 曲率が小さい＝目的関数があまり変わらない＝決まらない方向  

となります（Cov は $(J^T J)^{-1}$ に比例するため）。

---

### 2.7 誤差伝播による Ne(T) 推定誤差帯

モデル出力

$$
y(T)=\log_{10} N_e^{model}(T)
$$

の微分ベクトル $g=\partial y/\partial\theta$ を数値微分で求め、

$$
\mathrm{Var}[y(T)] \approx g^T \mathrm{Cov}(\theta) g
$$

より $\sigma_y(T)$ を得ます。  
これを用いて

$$
y(T)\pm n_\sigma\sigma_y(T)
$$

を計算し、プロットでは薄色帯で表示します（`--band_sigma` で倍率指定）。

---

### 2.8 固定すべきパラメータの推定（ヒューリスティック）

以下の要素をスコア化して候補を提案します。

- 相対誤差（stderr / |estimate|）が大きい
- 相関 |corr| が閾値以上（例 0.95）
- Cov の「最大不確か方向」の固有ベクトルに強く寄与

これは数値的な「決まりにくさ」の指標であり、最終判断は物理的妥当性・独立測定の有無で行ってください。

---

## 3. 使い方 (usage)

### 3.1 共通

- 入力ファイル：CSV または Excel  
- 温度列・Ne 列は 0 開始の列番号で指定  
- Excel の場合は `--sheet` でシート名または番号（例 "0"）を指定可能

主なモード：

- `--mode read` : データを表示・プロット  
- `--mode sim`  : 与えたパラメータで Ne(T) を計算・プロット（入力があれば重ね描き）  
- `--mode fit`  : データに対してパラメータフィット＋誤差解析＋誤差帯プロット  

---

### 3.2 主なオプション

I/O：
- `--input FILE` : 入力データ（CSV/Excel）
- `--sheet SHEET` : Excel シート名/番号
- `--temp_col N` : 温度列（0開始）
- `--ne_col N` : Ne列（0開始）

物理パラメータ（初期値/固定値）：
- `--Eg VALUE` : バンドギャップ Eg [eV]
- `--me VALUE` : 電子有効質量比
- `--mh VALUE` : 正孔有効質量比
- `--ND VALUE` : ドナー濃度 ND [cm^-3]
- `--NA VALUE` : アクセプター濃度 NA [cm^-3]
- `--ED VALUE` : ドナー準位深さ ED [eV]
- `--EA VALUE` : アクセプター準位深さ EA [eV]

フィット設定：
- `--method METHOD` : 最適化法（既定 nelder-mead）
- `--fix LIST` : 固定パラメータ（例 `EA,NA,Eg`）。対象は `ED,ND,EA,NA,Eg`
- `--Tfitmin VALUE` : フィットに使う最低温度[K]（既定 -1e100）
- `--Tfitmax VALUE` : フィットに使う最高温度[K]（既定 +1e100）

誤差帯・ヤコビアン設定：
- `--band_sigma VALUE` : 誤差帯幅（既定 1.0＝±1σ）
- `--jac_relstep VALUE` : 数値微分 相対ステップ（既定 1e-6）
- `--jac_absstep VALUE` : 数値微分 絶対ステップ（既定 1e-12）

出力：
- `--save FILE` : fit結果を保存する json（既定 fit_params.json）
- `--load FILE` : 初期値を json から読込
- `--diag_save FILE` : 共分散/相関/固有値などの診断 json（既定 fit_diagnostics_opt.json）
- `--suggest_save FILE` : 固定候補提案 json（既定 fit_fix_suggestions.json）

---

## 4. 使用例

### 4.1 データ表示（read）

例：Excel の 1列目が温度、4列目が Ne のとき（0開始で temp_col=0, ne_col=3）

python Ne-T_fit.py --input cIGZO-1e16.xlsx --ne_col 3 --mode read --temp_col 0

---

### 4.2 計算（sim）

例：入力データの温度点でモデル計算し、データに重ね描き

python Ne-T_fit.py --input cIGZO-1e16.xlsx --ne_col 3 --mode sim --Eg 3.5 --ND 1e17 --NA 0 --me 0.32 --ED 0.1

入力が無い場合は Tmin〜Tmax の等間隔点で計算します。

python Ne-T_fit.py --mode sim --Tmin 100 --Tmax 600 --nT 80 --Eg 3.5 --ND 1e17 --NA 0 --me 0.32 --ED 0.1

---

### 4.3 フィッティング（fit）

例：Eg, EA, NA を固定して n型側のみフィット（ED と ND を推定）

python Ne-T_fit.py --input cIGZO-1e16.xlsx --ne_col 3 --mode fit --Eg 3.5 --EA 0.22 --NA 0 --me 0.32 --ED 0.1 --fix Eg,EA,NA

例：特定の温度範囲だけでフィット（T=200〜500 K）

python Ne-T_fit.py --input cIGZO-1e16.xlsx --ne_col 3 --mode fit --Eg 3.5 --NA 0 --me 0.32 --ED 0.1 --Tfitmin 200 --Tfitmax 500 --fix Eg,EA,NA

例：誤差帯（±1σ）を安定化したい場合（誤差帯計算側の有限差分を大きめに）

python Ne-T_fit.py --input cIGZO-1e16.xlsx --ne_col 3 --mode fit --Eg 3.5 --NA 0 --me 0.32 --ED 0.1 --fix Eg,EA,NA --band_sigma 1.0 --jac_relstep 1e-4 --jac_absstep 1e-8

---

### 4.4 出力ファイルの確認

- fit結果：fit_params.json（`--save` で変更可）
- 診断（共分散・相関・固有値等）：fit_diagnostics_opt.json（`--diag_save`）
- 固定候補提案：fit_fix_suggestions.json（`--suggest_save`）

これらは後処理（表作成、報告資料、再フィットの初期値）に利用できます。

---

## 5. 重要な注意（数値安定性）

- F_{1/2} 積分の高速化のため、既定では eta を 1e-3 に量子化してキャッシュします。  
- しかし、数値ヤコビアン計算ではこの量子化により残差が段階的になり、J≈0 となることがあります。  
- 本プログラムは、ヤコビアン計算時のみ FD キャッシュ量子化を無効化（FD_CACHE_DISABLE=True）して回避します。  
- さらに誤差帯（prediction band）は、brentq や quad の数値ノイズの影響を受けやすいので、必要に応じて `--jac_relstep 1e-4 --jac_absstep 1e-8` など大きめの差分を推奨します。  
