#Prompt #4
#計算結果はよくなりましたが、overflow warningがでます
#D:\doc1.current\doc.学会発表\2026結晶工学セミナー\distribution\010-Ne_v3.py:18: RuntimeWarning: overflow encountered in exp
#  integrand = lambda x: np.sqrt(x) / (1 + np.exp(x - eta))
#Prompt#5
#今回は数値解析の講義ではなく、プログラム作成のチュートリアルなので、ライブラリを使うほうを優先したいです。expitで全コードを出力してください


import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import quad
from scipy.special import expit

# --- 定数設定 ---
k_B = 8.6173e-5  # ボルツマン定数 [eV/K]
T = 300           # 温度 [K]
Nc = 2.8e19       # 有効状態密度 [cm^-3] (Si, 300K)

def calculate_ne_with_expit(ef_ec_range, T, Nc):
    """
    expit (シグモイド関数) を使用してオーバーフローを回避し、
    数値積分で電子密度 Ne を計算する
    """
    kt = k_B * T
    ne_list = []
    
    for diff in ef_ec_range:
        eta = diff / kt
        
        # 被積分関数: sqrt(x) * (1 / (1 + exp(x - eta)))
        # expit(eta - x) は 1 / (1 + exp(-(eta - x))) = 1 / (1 + exp(x - eta)) と等価
        integrand = lambda x: np.sqrt(x) * expit(eta - x)
        
        # 積分範囲の設定: 
        # 強縮退時は x=eta 付近までが寄与のメインとなるため、
        # 余裕を持って上限を設定 (eta + 100程度)
        upper_limit = max(eta + 50, 100)
        
        f_half, _ = quad(integrand, 0, upper_limit)
        
        # キャリア密度の基本式: Ne = Nc * (2/√π) * F_{1/2}(eta)
        ne = Nc * (2.0 / np.sqrt(np.pi)) * f_half
        ne_list.append(ne)
        
    return np.array(ne_list)

# --- メイン処理 ---

# 1. Ef - Ec の範囲設定 (-0.6eV から 1.0eV)
ef_ec_values = np.linspace(-0.6, 1.0, 300)

# 2. 計算実行
ne_values = calculate_ne_with_expit(ef_ec_values, T, Nc)

# 3. プロット
plt.figure(figsize=(10, 7))

# メインの計算結果
plt.plot(ef_ec_values, ne_values, label='Fermi-Dirac (with expit)', color='blue', lw=2.5)

# 比較用：ボルツマン近似 (Ne = Nc * exp(eta))
ne_boltzmann = Nc * np.exp(ef_ec_values / (k_B * T))
plt.plot(ef_ec_values, ne_boltzmann, '--', label='Boltzmann Approx (limit: $E_F \ll E_C$)', color='red', alpha=0.6)

# グラフ装飾
plt.yscale('log')
plt.ylim(1e10, 1e23)
plt.title('Electron Density $N_e$ vs ($E_F - E_C$)\nNumerical Integration with `scipy.special.expit`', fontsize=14)
plt.xlabel('$E_F - E_C$ [eV]', fontsize=12)
plt.ylabel('$N_e$ [cm$^{-3}$]', fontsize=12)
plt.grid(True, which="both", ls="-", alpha=0.2)

# 縮退の境界線
plt.axvline(x=0, color='black', linestyle='-', lw=1)
plt.text(0.02, 1e11, 'Degenerate Region ($E_F > E_C$)', fontsize=10)

plt.legend(loc='upper left')
plt.tight_layout()

# プログラムの保存と表示
# plt.savefig("Ne_vs_Ef_expit.png", dpi=300)
plt.show()

# 数値の確認用
print(f"Calculation Complete.")
print(f"Ne at Ef-Ec = 0.0 eV: {ne_values[np.argmin(np.abs(ef_ec_values))]:.2e} cm^-3")
print(f"Ne at Ef-Ec = 1.0 eV: {ne_values[-1]:.2e} cm^-3")