import sys
import random
import numpy as np
from numpy import sqrt, exp, sin, cos, tan, pi


nMax = 10000000
seed = 0

if seed:
    random.srand(seed)


def Func(x):
    return sqrt(1.0 - x * x)


print("Hit-or-miss Monte-Carlo method")
print("i\tS\t|error|")

nHit = 0;
nt = 100;
for i in range(1, nMax + 1):
    x = random.random()
    y = random.random()
    r2 = x * x + y * y
    if r2 <= 1.0:
        nHit += 1

    if i == nt:
        S = 4.0 * nHit / i
        print(f"{i}\t{S:16.10f}\t", abs(S - pi))
        nt *= 2
print("")

print("crude Monte-Carlo method")
print("i\tS\t|error|")
Sum = 0
nt = 100;
for i in range(1, nMax + 1):
    x = random.random()
    y = Func(x)

    Sum += y
    if i == nt:
        print(f"{i}\t", 4.0 * Sum / i, "\t", abs(4.0 * Sum / i - pi))
        nt *= 2
print("")
