import sys

val10 = 0b110001

if len(sys.argv) > 1:
    val10 = int(sys.argv[1], 2)

def bit_reverse(val):
    ret = 0
    while 1:
        v0 = val & 0b001    # save the final bit to v0

        ret = ret | v0      # put v0 to the final bit of ret (will be the top digit of ret)
        val = val >> 1      # bit shift for next iteration
        if val == 0:
            break
        else:
            ret = ret << 1  # bit shift ret to left

    return ret


print("")
print("Base 10 input: ", val10)
print("Base 2: {:b}".format(val10))

vrev = bit_reverse(val10)
print("reversed in Base 10 =", vrev)
print("         in Base 2  = {:b}".format(vrev))
print("")
