import sys
import numpy as np
import matplotlib.pyplot as plt
from spectrum import pburg, Periodogram


infile = 'input_time_series.csv'
order  = 8  # ARモデルの次数

argv = sys.argv
nargs = len(argv)
if nargs > 1: infile = argv[1]
if nargs > 2: order = int(argv[2])


# ————————
# Load data (value 列のみ)
# ————————
# ヘッダー行をスキップして、2列目(value)を読み込み
_a = np.loadtxt(infile, delimiter=',', skiprows=1, usecols=[0,1])
t, x = _a.T
nfft = len(x)

# MEMスペクトル（Burg法）
burg_spec = pburg(x, order=order, NFFT=nfft)
mem_psd   = burg_spec.psd                      # MEM PSD
freqs_mem = burg_spec.frequencies()            # 周波数軸

# FFTベースPSD
fft_spec  = Periodogram(x, NFFT=nfft)
fft_psd   = fft_spec.psd
freqs_fft = fft_spec.frequencies()


# プロット(入力)
plt.figure(figsize=(8, 4))
plt.plot(t, x, label='input', linewidth=2)
plt.xlabel('t')
plt.ylabel('signal')
plt.title('Input signal')
#plt.legend()
#plt.grid(True)
plt.show()

# プロット比較
plt.figure(figsize=(8, 4))
plt.plot(freqs_mem, mem_psd, label='MEM (pburg)', linewidth=2)
plt.plot(freqs_fft, fft_psd, '--',      label='FFT PSD', linewidth=1)
#plt.plot(freqs_mem, np.log10(mem_psd), label='MEM (pburg)', linewidth=2)
#plt.plot(freqs_fft, np.log10(fft_psd), '--',      label='FFT PSD', linewidth=1)
#plt.yscale('log')
plt.xlabel('Frequency (Hz)')
plt.ylabel('PSD (dB)')
plt.title('Spectral Estimate: MEM vs FFT')
plt.legend()
#plt.grid(True)
plt.show()

