import sys
import random
import numpy as np
from numpy import sqrt, exp, sin, cos, tan, pi


nMax = 10000000
seed = 0

if seed:
    random.srand(seed)


print("Hit-or-miss Monte-Carlo method")
print("i\tV\t|error|")
nHit = 0;
nt = 100;
for i in range(1, nMax + 1):
    x = random.random()
    y = random.random()
    z = random.random()
    r2 = x * x + y * y + z * z
    if r2 <= 1.0:
        nHit += 1

    if i == nt:
        V = 8.0 * nHit / i
        print(f"{i}\t{V:16.10f}\t", abs(V - 4.0 * pi / 3.0))
        nt *= 2
print("")

