import numpy as np
from scipy.optimize import minimize

# 例として、2次関数の最小値を求める
def objective_function(x):
    return (x[0] - 1.0)**2 + (x[1] + 2)**2

initial_guess = [5, 5]
result = minimize(objective_function, initial_guess, method='Nelder-Mead')

print(f"Best position: {result.x}")
print(f"Best score: {result.fun}")
