import csv
import numpy as np
from numpy import sin, cos, tan, pi
import sys

x0   = 0.0
kmix = 1.0
eps = 1.0e-10
nmaxiter = 50

def func(x):
    return 0.25 * (-x*x*x + x*x - 2.0)


def main():
    global x0, kmix, eps, nmaxiter

    print("Solution of an equation by self-consistent method")

    x = x0
    for i in range(nmaxiter):
        xnext = func(x)
        dx = xnext - x
        print("Iter {:5d}: x: {:>16.12f} => {:>16.12f}, dx = {:>10.4g}".format(i, x, xnext, dx))
        if abs(dx) < eps:
            print("  Success: Convergence reached: dx = {} < eps = {}".format(dx, eps))
            return 1
        x = (1.0 - kmix) * x + kmix * xnext

    print("  Failed: Convergence did not reach: dx = {} > eps = {}".format(dx, eps))
    return 0


if __name__ == "__main__":
    main()
