#include <iostream>
#include <unordered_map>
#include <string>
#include <cstdlib>  // For std::atoi

std::string convertBase10ToBase20(int base10Value, const std::unordered_map<int, char>& base20Map) {
    std::string base20Value;
    while (base10Value > 0) {
        int remainder = base10Value % 20;
        base20Value = base20Map.at(remainder) + base20Value;
        base10Value /= 20;
    }
    return base20Value.empty() ? "0" : base20Value;
}

int main(int argc, char* argv[]) {
    if (argc != 2) {
        std::cerr << "Usage: " << argv[0] << " <base10Value>" << std::endl;
        return 1;
    }

    int base10Value = std::atoi(argv[1]);

    std::unordered_map<int, char> base20Map = {
        {0, '0'}, {1, '1'}, {2, '2'}, {3, '3'}, {4, '4'},
        {5, '5'}, {6, '6'}, {7, '7'}, {8, '8'}, {9, '9'},
        {10, 'A'}, {11, 'B'}, {12, 'C'}, {13, 'D'}, {14, 'E'},
        {15, 'F'}, {16, 'G'}, {17, 'H'}, {18, 'I'}, {19, 'J'},
        {20, 'K'}
    };

    std::string base20Value = convertBase10ToBase20(base10Value, base20Map);

    std::cout << "Base 10 value: " << base10Value << std::endl;
    std::cout << "Base 20 value: " << base20Value << std::endl;

    return 0;
}