from math import exp, factorial

"""
  Error due to information buried: exp(-x) for large x
"""
#===================
# parameters
#===================
x = -40.0
nmax = 120

#===================
# main routine
#===================
print("Error due to information buried: exp(-x) for large x")
print("")

exact = exp(x)
print(f"exact: exp({x}) = {exact}")

print("{'n':^3}:\t{'sum(x^n/n!)':^18}\t{'1 / sum((-x)^n/n!)':^18}")

s1 = 0.0
s2 = 0.0
for n in range(nmax):
    nfact = factorial(n)
    s1 += pow(x, n) / nfact
    s2 += pow(-x, n) / nfact
    print(f"{n:^3d}:\t{s1:>18.8g}\t{1.0/s2:>18.8g}\t")
