import sys


#===================
# parameters
#===================
h      = 0.01
n      = 100
answer = 1.0
eps    = 1.0e-10

def getintarg(iarg, defval = None):
    try:
        return int(argv[iarg])
    except:
        return defval
        
def getfloatarg(iarg, defval = None):
    try:
        return float(argv[iarg])
    except:
        return defval


argv = sys.argv
narg = len(argv)
if narg <= 2:
    print("")
    print("Usage: python bad_if.py h n answer")
    print("    Check the condition h * n == answer")
    print("")
    exit()
else:
    h      = getfloatarg(1, h)
    n      = getintarg(2, n)
    answer = getfloatarg(3, answer)

#===================
# main routine
#===================
v = 0.0
for i in range(n):
    v += h

print("")
print(f"Summing up {h} for {n} times: v = {v}")
print(f"v == {answer}?: {v == answer}")
print(f"|v - {answer}| < {eps}?: {abs(v - answer) < eps}")

print("")
