from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import sys
from types import SimpleNamespace


# --- グローバル変数 ---
#rotate_x, rotate_z = 0.0, 0.0
rotate_x, rotate_z = 20.0, 30.0
zoom = 1.0
pan_x, pan_y = 0.0, 0.0
pan_step = 10
last_x, last_y = 0, 0
mouse_drag = False

# --- TFT構造を描画する ---
def draw_box(x, y, z, dx, dy, dz, color):
    r, g, b = color

    # --- 塗りつぶし（面）の描画 ---
    glColor3f(r, g, b)
    glBegin(GL_QUADS)

    # 各面（省略せずに正確に記述）
    glVertex3f(x, y, z)
    glVertex3f(x + dx, y, z)
    glVertex3f(x + dx, y + dy, z)
    glVertex3f(x, y + dy, z)

    glVertex3f(x, y, z + dz)
    glVertex3f(x + dx, y, z + dz)
    glVertex3f(x + dx, y + dy, z + dz)
    glVertex3f(x, y + dy, z + dz)

    glVertex3f(x, y + dy, z)
    glVertex3f(x + dx, y + dy, z)
    glVertex3f(x + dx, y + dy, z + dz)
    glVertex3f(x, y + dy, z + dz)

    glVertex3f(x, y, z)
    glVertex3f(x + dx, y, z)
    glVertex3f(x + dx, y, z + dz)
    glVertex3f(x, y, z + dz)

    glVertex3f(x, y, z)
    glVertex3f(x, y + dy, z)
    glVertex3f(x, y + dy, z + dz)
    glVertex3f(x, y, z + dz)

    glVertex3f(x + dx, y, z)
    glVertex3f(x + dx, y + dy, z)
    glVertex3f(x + dx, y + dy, z + dz)
    glVertex3f(x + dx, y, z + dz)

    glEnd()

    # --- 黒色の線で輪郭を描く ---
    glColor3f(0.0, 0.0, 0.0)  # 黒色
    glLineWidth(2.0)
    glBegin(GL_LINES)

    # 8頂点
    p = [
        (x, y, z),
        (x + dx, y, z),
        (x + dx, y + dy, z),
        (x, y + dy, z),
        (x, y, z + dz),
        (x + dx, y, z + dz),
        (x + dx, y + dy, z + dz),
        (x, y + dy, z + dz),
    ]

    # エッジ12本
    edges = [
        (0, 1), (1, 2), (2, 3), (3, 0),
        (4, 5), (5, 6), (6, 7), (7, 4),
        (0, 4), (1, 5), (2, 6), (3, 7)
    ]

    for a, b in edges:
        glVertex3fv(p[a])
        glVertex3fv(p[b])

    glEnd()

# --- 描画処理 ---
def display():
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()

    # カメラ位置（固定）
#    gluLookAt(0.0, -200.0, 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)
    gluLookAt(0, -200.0 * zoom, 150.0 * zoom, 0, 0, 0, 0, 0, 1)
#    gluLookAt(0, -10 * zoom, 5 * zoom, 0, 0, 0, 0, 0, 1)

    glTranslatef(pan_x, pan_y, 0)
    glRotatef(rotate_x, 1.0, 0.0, 0.0)
    glRotatef(rotate_z, 0.0, 0.0, 1.0)

    # --- スケール調整 ---
    scale = 0.0002
    hscale = 1.0e3
    vscale = 1.0e2

    cfg = SimpleNamespace()
    cfg.W = 200.0    # micrometer
    cfg.L = 50.0
    cfg.dg = 200     # nanometer

    W = cfg.W * hscale * scale
    L_semi = cfg.L * hscale * scale
    L_sd = 200.0 * hscale * scale

    d_ins = cfg.dg * vscale * scale  # nanometer
    d_sub  = 1000.0 * vscale * scale
    d_gate = 200.0 * vscale * scale
    d_semi = 100.0 * vscale * scale
    d_sd = 100.0 * vscale * scale
    x_tot = 2.0 * L_sd + L_semi

    z = 0.0
    substrate_margin = 2.0
    draw_box(-x_tot / 2 * substrate_margin, -W / 2 * substrate_margin, z, 
            x_tot * substrate_margin, W * substrate_margin, d_sub, (0.0, 1.0, 1.0))         # substrate
    z += d_sub
    draw_box(-x_tot / 2 * substrate_margin, -W / 2 * substrate_margin, z, 
            x_tot * substrate_margin, W * substrate_margin, d_gate, (0.75, 0.75, 0.75))     # gate
    z += d_gate
    draw_box(-x_tot / 2 * substrate_margin, -W / 2 * substrate_margin, z, 
            x_tot * substrate_margin, W * substrate_margin, d_ins, (0.5, 0.75, 1.0))        # insulator
    z += d_ins
    draw_box(-x_tot / 2, -W / 2, z, x_tot, W, d_semi, (1.0, 0.5, 0.0))        # semiconductor
    z += d_semi
    draw_box(-x_tot / 2, -W / 2, z, L_sd, W, d_sd, (0.7, 0.7, 0.7))           # source
    draw_box(x_tot / 2 - L_sd, -W / 2, z, L_sd, W, d_sd, (0.7, 0.7, 0.7))     # drain

    glutSwapBuffers()

# --- 初期化 ---
def init():
    glClearColor(1.0, 1.0, 1.0, 1.0)
#    glClearColor(0.6, 0.8, 1.0, 1.0)
    glEnable(GL_DEPTH_TEST)
    glMatrixMode(GL_PROJECTION)
    gluPerspective(60.0, 1.33, 1.0, 1000.0)  # zFarを100→500へ
    glMatrixMode(GL_MODELVIEW)


# --- リサイズ対応（必要なら） ---
def reshape(w, h):
    glViewport(0, 0, w, h)

# --- キーボード操作 ---
def keyboard(key, x, y):
    global zoom
    global pan_x, pan_y

    if key == b'+':
        zoom *= 0.9
    elif key == b'-':
        zoom *= 1.1
    elif key == b'h':
#        print("left")
        pan_x -= pan_step
    elif key == b'l':
#        print("right")
        pan_x += pan_step
    elif key == b'k':
#        print("up")
        pan_y += pan_step
    elif key == b'j':
#        print("down")
        pan_y -= pan_step

    glutPostRedisplay()

# --- 矢印キーで平行移動 ---
def special(key, x, y):
    global pan_x, pan_y

    if key == GLUT_KEY_LEFT:
#        print("left")
        pan_x -= pan_step
    elif key == GLUT_KEY_RIGHT:
#        print("right")
        pan_x += pan_step
    elif key == GLUT_KEY_UP:
#        print("up")
        pan_y += pan_step
    elif key == GLUT_KEY_DOWN:
#        print("down")
        pan_y -= pan_step
    glutPostRedisplay()

# --- マウスドラッグ ---
def mouse(button, state, x, y):
    global last_x, last_y, mouse_drag
    if state == GLUT_DOWN:
        last_x, last_y = x, y
        mouse_drag = True
    else:
        mouse_drag = False

def motion(x, y):
    global rotate_x, rotate_z, last_x, last_y
    dx = x - last_x
    dy = y - last_y
    rotate_z += dx * 0.5
    rotate_x += dy * 0.5
    last_x, last_y = x, y
    glutPostRedisplay()

# --- メイン関数 ---
def main():
    glutInit(sys.argv)
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH)
    glutInitWindowSize(800, 600)
    glutCreateWindow(b"TFT Viewer with Interaction - PyOpenGL")
    init()
    glutDisplayFunc(display)
    glutReshapeFunc(reshape)
    glutKeyboardFunc(keyboard)
    glutSpecialFunc(special)
    glutMouseFunc(mouse)
    glutMotionFunc(motion)
    glutMainLoop()

if __name__ == "__main__":
    main()
