# split_icons.py ドキュメント

## 1) プログラムの動作
`split_icons.py` は、指定された画像ファイルを指定された行数と列数に分割し、それぞれの部分を個別の画像ファイルとして保存するプログラムです。デフォルトでは、3行3列のアイコンに分割されます。分割されたアイコンは、指定された出力ディレクトリに PNG 形式で保存されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、Python Imaging Library (PIL) のフォークである `Pillow` ライブラリを使用しています。

### インストールコマンド
```bash
pip install Pillow
```

### インストール方法
1. コマンドラインを開きます。
2. 上記のインストールコマンドを入力して実行します。

## 3) 必要な入力ファイル
プログラムを実行するには、分割したい画像ファイルが必要です。デフォルトでは、`icons.png` という名前の画像ファイルが必要です。このファイルは、プログラムが実行されるディレクトリに存在する必要があります。

## 4) 実行後に生成される出力ファイル
プログラムを実行すると、指定された出力ディレクトリに分割されたアイコンが PNG 形式で保存されます。ファイル名は `icon_row_col.png` の形式で、`row` と `col` はそれぞれアイコンの行番号と列番号を示します。

例:
- `icon_0_0.png`
- `icon_0_1.png`
- `icon_1_0.png`
- `icon_1_1.png`
- など

## 5) コマンドラインでの使用例 (Usage)
プログラムをコマンドラインから実行するには、以下のようにします。

```bash
python split_icons.py
```

デフォルトでは、`icons.png` という画像を現在のディレクトリに分割し、出力も同じディレクトリに保存します。出力先のディレクトリを変更したい場合は、`split_image` 関数を直接呼び出す必要があります。