## プログラム解析: `split_audio_with_overlap.py`

### 1) プログラムの動作

このPythonスクリプトは、指定された音声ファイルを、指定された最大ファイルサイズ（MB）を基準に複数の小さなチャンクに分割します。分割された各チャンクは、次のチャンクと指定された秒数だけオーバーラップする（重なり合う）特性を持ちます。これは、例えば長尺の講演やオーディオブックを分割する際に、区切りの良い部分で聞き逃しがないようにするために有用です。

主な機能と動作ロジックは以下の通りです。

1.  **引数の解析**:
    *   必須引数として入力音声ファイルのパスを受け取ります。
    *   オプション引数として、出力フォーマット、ビットレート、チャンクの最大サイズ（MB）、オーバーラップ時間（秒）を指定できます。これらが指定されない場合、スクリプト内のデフォルト値が使用されます。

2.  **音声ファイルの読み込み**:
    *   `pydub` ライブラリを使用して、入力された音声ファイルを読み込みます。`pydub` は様々な音声フォーマットに対応しており、自動的に適切なフォーマットを検出します。

3.  **チャンク長の計算**:
    *   指定された出力ビットレート（例: `128k`）とチャンクの最大サイズ（MB）に基づいて、1チャンクあたりの最大秒数（`max_chunk_sec`）を計算します。
    *   この最大秒数からオーバーラップ時間を差し引いた値が、次のチャンクの開始位置（`step`）となります。これにより、オーバーラップが実現されます。

4.  **出力ディレクトリの準備**:
    *   入力ファイルがあるディレクトリと同じ階層に、`split_fixed` という名前のディレクトリを作成します（既に存在する場合は再利用）。分割された音声ファイルはこのディレクトリに保存されます。

5.  **音声の分割と保存**:
    *   計算された `max_chunk_sec` と `step` を使用して、入力音声をループで分割していきます。
    *   各チャンクは、元のファイル名に連番（例: `_000`, `_001`）を付加し、指定された出力フォーマットとビットレートで新しいファイルとして保存されます。
    *   最後のチャンクは、残りの音声全体が対象となり、必ずしも `max_chunk_sec` の長さになるとは限りません。

### 2) 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは、音声処理に `pydub` ライブラリを使用します。また、`pydub` は内部的に音声ファイルのエンコード・デコードに [FFmpeg](https://ffmpeg.org/) を利用します。そのため、`pydub` と `FFmpeg` の両方が必要です。

**必要な非標準ライブラリ:**
*   `pydub`

**インストールコマンド:**

1.  **`pydub` のインストール:**
    ```bash
    pip install pydub
    ```

2.  **FFmpeg のインストール:**
    `FFmpeg` はOSによってインストール方法が異なります。以下に一般的な方法を示します。

    *   **Windows:**
        1.  [FFmpeg公式サイト](https://ffmpeg.org/download.html) からビルド済みのバイナリをダウンロードします。
        2.  ダウンロードしたZIPファイルを展開し、`bin` フォルダ内の `ffmpeg.exe` が含まれるパスをシステム環境変数 `PATH` に追加します。
        3.  または、展開した `ffmpeg.exe` をPythonスクリプトと同じディレクトリ、または `pydub` が検索する標準的なパスに配置します。

    *   **macOS:**
        [Homebrew](https://brew.sh/) を使用するのが最も簡単です。
        ```bash
        brew install ffmpeg
        ```

    *   **Linux (Debian/Ubuntu系):**
        ```bash
        sudo apt update
        sudo apt install ffmpeg
        ```

    *   **Linux (CentOS/RHEL系):**
        ```bash
        sudo yum install epel-release
        sudo yum localinstall --nogpgcheck https://download1.rpmfusion.org/free/el/rpmfusion-free-release-7.noarch.rpm
        sudo yum install ffmpeg ffmpeg-devel
        ```

### 3) 必要な入力ファイル

*   **`<input_audio_file>`**: 分割したい元の音声ファイル。
    *   このファイルは、コマンドライン引数の最初の引数として指定する必要があります。
    *   `pydub` と `FFmpeg` がサポートするあらゆるオーディオフォーマット（例: `.mp3`, `.wav`, `.flac`, `.m4a`, `.ogg` など）が利用可能です。

### 4) 実行後に生成される出力ファイル

*   **出力ディレクトリ**:
    *   入力音声ファイルが存在するディレクトリのサブディレクトリとして `split_fixed` が作成されます。
        例: `/path/to/my_audio.mp3` を入力した場合、出力は `/path/to/split_fixed/` に生成されます。

*   **出力ファイル**:
    *   分割された各音声チャンクは、以下の命名規則で上記の出力ディレクトリに保存されます。
        `[元のファイル名本体]_[連番].` `[出力フォーマット]`
    *   **ファイル名本体**: 入力ファイル名から拡張子を除いた部分。
    *   **連番**: 0から始まる3桁のゼロ埋めされた整数（例: `000`, `001`, `002`, ...）。
    *   **出力フォーマット**: 指定された出力形式（デフォルトは `mp3`）。

    **例:**
    入力ファイル: `long_interview.wav`
    出力フォーマット: `mp3`
    生成されるファイル:
    *   `split_fixed/long_interview_000.mp3`
    *   `split_fixed/long_interview_001.mp3`
    *   `split_fixed/long_interview_002.mp3`
    *   ... など

### 5) コマンドラインでの使用例 (Usage)

スクリプトは以下の形式で実行します。角括弧 `[]` で囲まれた引数はオプションです。

```bash
python split_audio_with_overlap.py <input_audio_file> [output_format] [bitrate] [max_size_mb] [overlap_sec]
```

**引数の説明:**

*   `<input_audio_file>`: (必須) 分割する元の音声ファイルのパス。
*   `[output_format]`: (オプション) 出力ファイルのフォーマット。デフォルトは `mp3`。（例: `wav`, `flac`, `mp3`）
*   `[bitrate]`: (オプション) 出力ファイルのビットレート。デフォルトは `128k`。（例: `64k`, `192k`, `256k`）
*   `[max_size_mb]`: (オプション) 各チャンクの最大ファイルサイズ（メガバイト）。デフォルトは `150` MB。
*   `[overlap_sec]`: (オプション) 各チャンク間のオーバーラップ時間（秒）。デフォルトは `60` 秒。

**使用例:**

1.  **最も基本的な使い方（デフォルト設定を使用）:**
    （入力ファイル `my_long_podcast.wav` をデフォルト設定で分割し、`split_fixed` ディレクトリに `my_long_podcast_000.mp3` などを出力）
    ```bash
    python split_audio_with_overlap.py my_long_podcast.wav
    ```

2.  **出力フォーマットを指定:**
    （入力ファイル `lecture.m4a` を `wav` フォーマットで出力）
    ```bash
    python split_audio_with_overlap.py lecture.m4a wav
    ```

3.  **出力フォーマットとビットレートを指定:**
    （入力ファイル `music.flac` を `mp3` 形式で `256k` ビットレートで出力）
    ```bash
    python split_audio_with_overlap.py music.flac mp3 256k
    ```

4.  **最大サイズとオーバーラップ時間を指定:**
    （入力ファイル `audiobook.mp3` を、チャンクの最大サイズを `100MB`、オーバーラップを `30秒` として出力）
    ```bash
    python split_audio_with_overlap.py audiobook.mp3 mp3 128k 100 30
    ```
    *注: `max_size_mb` と `overlap_sec` は数値として解釈されるため、単位は不要です。*

5.  **すべてのオプションを指定:**
    ```bash
    python split_audio_with_overlap.py path/to/my_audio.ogg wav 192k 75 45
    ```
    （`path/to/my_audio.ogg` を入力として、`wav` フォーマット、`192k` ビットレート、最大 `75MB` のチャンク、`45秒` のオーバーラップで分割）