# split_audio.py ドキュメント

## 1) プログラムの動作
`split_audio.py` は、指定された音声ファイルを文節に基づいて分割し、指定されたサイズ制限内で複数のオーディオファイルとして保存するプログラムです。音声ファイルの文字起こしには OpenAI の Whisper モデルを使用し、分割されたオーディオは指定されたフォーマットとビットレートで保存されます。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています。

- `whisper`: OpenAI の音声認識モデル
- `pydub`: 音声ファイルの操作を行うライブラリ

### インストール方法
以下のコマンドを使用して、必要なライブラリをインストールできます。

```bash
pip install git+https://github.com/openai/whisper.git
pip install pydub
```

また、`pydub` を使用するためには、FFmpeg が必要です。FFmpeg をインストールするには、以下のコマンドを使用します（OS によって異なる場合があります）。

- **Ubuntu**:
  ```bash
  sudo apt install ffmpeg
  ```

- **macOS** (Homebrew):
  ```bash
  brew install ffmpeg
  ```

- **Windows**: FFmpeg の公式サイトからバイナリをダウンロードし、パスを設定してください。

## 3) 必要な入力ファイル
プログラムは、音声ファイル（例: `your_audio.mp3`）を入力として受け取ります。デフォルトでは、`your_audio.mp3` という名前のファイルが必要です。コマンドライン引数を使用して、異なるファイルを指定することもできます。

## 4) 実行後に生成される出力ファイル
プログラムは、指定された出力ディレクトリ内に分割されたオーディオファイルを生成します。ファイル名は `chunk_000.mp3`, `chunk_001.mp3`, ... の形式で、指定された出力フォーマット（デフォルトは `mp3`）で保存されます。

## 5) コマンドラインでの使用例 (Usage)
以下のコマンドを使用してプログラムを実行できます。

```bash
python split_audio.py [input_file] [output_dir] [model_size] [max_size_mb] [output_format] [bitrate]
```

### 引数の説明
- `input_file`: 入力音声ファイルのパス（デフォルト: `your_audio.mp3`）
- `output_dir`: 出力ディレクトリ（デフォルト: `split_audio`）
- `model_size`: Whisper モデルのサイズ（例: `small`, `medium`, `large`）（デフォルト: `small`）
- `max_size_mb`: 各出力ファイルの最大サイズ（MB単位）（デフォルト: `150`）
- `output_format`: 出力ファイルのフォーマット（例: `mp3`, `wav`, `flac`）（デフォルト: `mp3`）
- `bitrate`: 出力ファイルのビットレート（例: `128k`, `192k`）（デフォルト: `128k`）

### 使用例
```bash
python split_audio.py my_audio.mp3 output_folder small 100 wav 192k
```

このコマンドは、`my_audio.mp3` を `output_folder` に最大 100MB の `wav` フォーマットで分割保存します。ビットレートは `192k` に設定されています。