import sys
from PIL import Image

#argvでinput_image, output_imageを受け取る
if len(sys.argv) != 3:  
    print("使用法: python resize_image.py <input_image> <output_image>")
    sys.exit(1)
input_image = sys.argv[1]
output_image = sys.argv[2]


def resize_image(input_path, output_path, size=(128, 128)):
    try:
        # 画像を開く
        img = Image.open(input_path)
        # リサイズ（LANCZOSに修正）
        img_resized = img.resize(size, Image.Resampling.LANCZOS)
        # 保存
        img_resized.save(output_path)
        print(f"リサイズされた画像を {output_path} に保存しました！")
    except Exception as e:
        print(f"エラー: {e}")

# 使用例
resize_image(input_image, output_image)
