# resize_image.py ドキュメント

## 1) プログラムの動作
このプログラムは、指定された入力画像をリサイズし、指定された出力ファイルに保存する機能を持っています。デフォルトのリサイズサイズは128x128ピクセルです。コマンドライン引数として入力画像のパスと出力画像のパスを受け取り、PIL（Python Imaging Library）を使用して画像の処理を行います。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは、PIL（Pillow）ライブラリを使用しています。以下のコマンドでインストールできます。

```bash
pip install Pillow
```

## 3) 必要な入力ファイル
プログラムを実行するには、リサイズしたい画像ファイルのパスを指定する必要があります。このファイルは、JPEG、PNG、GIFなどの一般的な画像フォーマットである必要があります。

## 4) 実行後に生成される出力ファイル
プログラムが正常に実行されると、指定された出力ファイルのパスにリサイズされた画像が保存されます。出力ファイルのフォーマットは、指定されたファイル名の拡張子に基づいて決まります。

## 5) コマンドラインでの使用例 (Usage)
プログラムは以下のようにコマンドラインから実行します。

```bash
python resize_image.py <input_image> <output_image>
```

### 例
```bash
python resize_image.py input.jpg output.jpg
```

このコマンドは、`input.jpg`を128x128ピクセルにリサイズし、`output.jpg`として保存します。