import os
import sys
import glob
from pymediainfo import MediaInfo

#media_patterns = ['**/*.mp4', '**/*.mp3', '**/*.wav', '**/*.flac'] 
media_patterns = ['*.mp4', '*.mp3', '*.wav', '*.flac'] 

argv = sys.argv[1:] # コマンドライン引数を取得
if len(argv) >= 1:
    media_patterns = argv


def get_media_details(file_path):
    """
    指定されたメディアファイルの詳細情報を取得して表示する関数。
    """

    try:
        media_info = MediaInfo.parse(file_path)
        print(f"\n--- ファイル: {file_path} ---")
        
        found_audio = False
        found_video = False

        for track in media_info.tracks:
            if track.track_type == "General":
                # 各属性が存在し、かつ数値型であることを確認してからフォーマットする
                if track.file_size is not None and isinstance(track.file_size, (int, float)):
                    print(f"  ファイルサイズ: {track.file_size / (1024 * 1024):.2f} MB")
                else:
                    print("  ファイルサイズ: N/A")

                if track.duration is not None and isinstance(track.duration, (int, float)):
                    sec = track.duration / 1000
                    min = sec / 60.0
                    hour = int(min / 60.0)
                    min = int(min - hour * 60)
                    sec = int(sec - min * 60 - hour * 60 * 60)
                    print(f"  Duration: {hour:02d}:{min:02d}:{sec:02d}")
                else:
                    print("  Duration: N/A")

                if track.overall_bit_rate is not None and isinstance(track.overall_bit_rate, (int, float)):
                    print(f"  Overall Bit Rate: {track.overall_bit_rate / 1000:.2f} kbps")
                else:
                    print("  Overall Bit Rate: N/A")
                
                if track.format: # formatは文字列なのでそのまま表示
                    print(f"  コンテナ形式: {track.format}")
                else:
                    print("  コンテナ形式: N/A")

            elif track.track_type == "Video":
                found_video = True
                print("\n  [動画トラック情報]")
                
                if track.codec_id:
                    print(f"    エンコード形式 (Codec ID): {track.codec_id}")
                else:
                    print("    エンコード形式 (Codec ID): N/A")
                
                if track.format:
                    print(f"    エンコード形式 (Format): {track.format}")
                else:
                    print("    エンコード形式 (Format): N/A")
                
                if track.bit_rate is not None and isinstance(track.bit_rate, (int, float)):
                    print(f"    Bit Rate (平均): {track.bit_rate / 1000:.2f} kbps")
                else:
                    print("    Bit Rate (平均): N/A")
                
                # ここにbit_rate_modeを追加
                if track.bit_rate_mode:
                    print(f"    Bit Rate Mode: {track.bit_rate_mode}")
                else:
                    print("    Bit Rate Mode: N/A (または不明)")

                if track.width is not None and isinstance(track.width, int): # widthは整数
                    print(f"    Width: {track.width}px")
                else:
                    print("    Width: N/A")
                
                if track.height is not None and isinstance(track.height, int): # heightも整数
                    print(f"    Height: {track.height}px")
                else:
                    print("    Height: N/A")
                
                if track.frame_rate is not None and isinstance(track.frame_rate, (int, float)):
                    print(f"    Frame Rate: {track.frame_rate:.2f} fps")
                else:
                    print("    Frame Rate: N/A")
                
                if track.display_aspect_ratio is not None and isinstance(track.display_aspect_ratio, (int, float)):
                    print(f"    Aspect Ratio: {track.display_aspect_ratio:.2f}")
                else:
                    print("    Aspect Ratio: N/A")

            elif track.track_type == "Audio":
                found_audio = True
                print("\n  [音声トラック情報]")
                
                if track.codec_id:
                    print(f"    エンコード形式 (Codec ID): {track.codec_id}")
                else:
                    print("    エンコード形式 (Codec ID): N/A")
                
                if track.format:
                    print(f"    エンコード形式 (Format): {track.format}")
                else:
                    print("    エンコード形式 (Format): N/A")
                
                if track.bit_rate is not None and isinstance(track.bit_rate, (int, float)):
                    print(f"    Bit Rate (平均): {track.bit_rate / 1000:.2f} kbps")
                else:
                    print("    Bit Rate (平均): N/A")
                
                # ここにbit_rate_modeを追加
                if track.bit_rate_mode:
                    print(f"    Bit Rate Mode: {track.bit_rate_mode}")
                else:
                    print("    Bit Rate Mode: N/A (または不明)")

                if track.sampling_rate is not None and isinstance(track.sampling_rate, (int, float)):
                    print(f"    Sampling Rate: {track.sampling_rate / 1000:.1f} kHz")
                else:
                    print("    Sampling Rate: N/A")
                
                if track.channel_s is not None and isinstance(track.channel_s, int): # channel_sは整数
                    print(f"    Channels: {track.channel_s}")
                else:
                    print("    Channels: N/A")

        if not found_video and not found_audio:
            print("  注意: 動画または音声トラックが見つかりませんでした。")

    except Exception as e:
        print(f"エラー: {file_path} の情報取得中にエラーが発生しました - {e}")

def main():
    print("media_patterns: ", media_patterns)
    
    found_files = []
    for pattern in media_patterns:
        found_files.extend(glob.glob(pattern, recursive=True))

    if not found_files:
        print("指定されたパターンにマッチする動画・音声ファイルは見つかりませんでした。")
        print("検索パターンを確認してください。例: '**/*.mp4', 'C:/Users/YourUser/Music/*.mp3'")
        return

#    print(f"--- {len(found_files)} 個のメディアファイルを検出しました ---")
    for file_path in sorted(list(set(found_files))):
        get_media_details(file_path)

    input("\nPress ENTER to terminate>>\n")
    
    
if __name__ == "__main__":
    main()