# media_inf.py Documentation

## 1) プログラムの動作
`media_inf.py`は、指定されたメディアファイル（動画および音声ファイル）の詳細情報を取得し、コンソールに表示するPythonプログラムです。プログラムは、コマンドライン引数として受け取ったファイルパターンに基づいて、指定されたディレクトリ内のメディアファイルを検索します。各ファイルについて、ファイルサイズ、再生時間、ビットレート、コンテナ形式、動画トラックや音声トラックの詳細情報を表示します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `pymediainfo`: メディアファイルのメタデータを取得するためのライブラリ。

### インストールコマンド
```bash
pip install pymediainfo
```

### インストール方法
1. Pythonがインストールされていることを確認します。
2. コマンドラインまたはターミナルを開きます。
3. 上記のインストールコマンドを入力して実行します。

## 3) 必要な入力ファイル
プログラムは、コマンドライン引数としてメディアファイルのパターンを受け取ります。デフォルトでは、以下のパターンが使用されます。

- `*.mp4`
- `*.mp3`
- `*.wav`
- `*.flac`

これらのパターンにマッチするメディアファイルが、プログラムが実行されるディレクトリ内に存在する必要があります。

## 4) 実行後に生成される出力ファイル
このプログラムは、出力ファイルを生成しません。代わりに、メディアファイルの詳細情報をコンソールに表示します。表示される情報には、ファイルサイズ、再生時間、ビットレート、コンテナ形式、動画トラックおよび音声トラックの詳細が含まれます。

## 5) コマンドラインでの使用例 (Usage)
プログラムを実行するには、コマンドラインで以下のように入力します。

```bash
python media_inf.py [ファイルパターン]
```

### 例
デフォルトのパターンを使用して実行する場合:
```bash
python media_inf.py
```

特定のファイルパターンを指定して実行する場合:
```bash
python media_inf.py "*.mp4" "*.mp3"
```

このコマンドは、カレントディレクトリ内のすべての`.mp4`および`.mp3`ファイルの詳細情報を表示します。