# xlsx2img.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、指定されたExcelファイルをPDF形式に変換し、そのPDFをページごとに画像ファイル（PNG形式など）に変換します。プログラムは以下の手順で動作します：
1. ExcelファイルをPDFに変換するために、Excelアプリケーションを起動します。
2. PDFファイルを生成します。
3. 生成されたPDFファイルを開き、各ページを画像として保存します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています：

- `comtypes`: Windows上でCOMオブジェクトを操作するためのライブラリ。
- `fitz` (PyMuPDF): PDFファイルを操作するためのライブラリ。

### インストールコマンド
以下のコマンドを使用して、必要なライブラリをインストールできます。

```bash
pip install comtypes PyMuPDF
```

### インストール方法
1. Pythonがインストールされていることを確認します。
2. 上記のコマンドをコマンドラインまたはターミナルで実行します。

## 3) 必要な入力ファイル
- `test.xlsx`: 変換対象のExcelファイル。プログラム内でデフォルトのファイル名として指定されていますが、コマンドライン引数で別のファイル名を指定することも可能です。

## 4) 実行後に生成される出力ファイル
- `output.pdf`: Excelファイルを変換して生成されるPDFファイル。
- `images/`: PDFの各ページを画像として保存するディレクトリ。ページごとに`page_1.png`, `page_2.png`, ... の形式で画像ファイルが生成されます。画像のフォーマットは、コマンドライン引数で指定することができます。

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行できます：

```bash
python xlsx2img.py [excel_file] [output_directory] [image_format]
```

### 引数の説明
- `excel_file`: 変換するExcelファイルのパス（省略時は`test.xlsx`）。
- `output_directory`: 画像を保存するディレクトリのパス（省略時は`images`）。
- `image_format`: 生成する画像のフォーマット（省略時は`png`）。

### 使用例
```bash
python xlsx2img.py my_excel_file.xlsx output_images jpg
```
このコマンドは、`my_excel_file.xlsx`をPDFに変換し、`output_images`ディレクトリにJPEG形式で画像を保存します。