# txt2pdf.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、指定されたテキストファイルをPDF形式に変換します。コマンドライン引数として入力ファイルのパスを受け取り、オプションで出力ファイルのパスを指定できます。出力ファイルが指定されていない場合、入力ファイル名に基づいて自動的にPDFファイル名が生成されます。プログラムは、テキストファイルの内容を読み込み、PDFに書き込む際に日本語フォントを使用します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、`fpdf2`ライブラリを使用しています。以下のコマンドでインストールできます。

```bash
pip install fpdf2
```

### インストール方法
1. コマンドラインを開きます。
2. 上記のコマンドを入力して実行します。

## 3) 必要な入力ファイル
プログラムは、テキストファイル（.txt形式）を入力ファイルとして必要とします。ファイルはUTF-8エンコーディングである必要があります。ファイルが存在しない場合や空の場合は、エラーメッセージが表示されます。

## 4) 実行後に生成される出力ファイル
プログラムの実行後、指定された出力ファイル名（または自動生成されたファイル名）でPDFファイルが生成されます。出力ファイルは、入力ファイルと同じディレクトリに保存されます。

## 5) コマンドラインでの使用例 (Usage)
以下は、プログラムのコマンドラインでの使用例です。

```bash
python txt2pdf.py input.txt output.pdf
```

- `input.txt` は変換したいテキストファイルのパスです。
- `output.pdf` は生成されるPDFファイルのパスです（省略可能）。省略した場合、`input.txt` に基づいて `input.pdf` という名前のPDFが生成されます。

### 注意
- 日本語フォント（MS-Gothic）が必要です。Windows環境では、フォントのパスが自動的に設定されますが、他の環境では適切なフォントを指定する必要があります。