このPythonプログラム `read_BRUKER_raw.py` は、Bruker製またはRigaku製X線回折装置で取得されたと思われるデータファイルを解析するためのツールです。テキスト形式のデータファイル（`.txt`）と、それに対応するバイナリ形式の生データファイル（`.raw`）を読み込み、それぞれのファイルからメタデータと測定データを抽出し、それらを比較表示し、最終的にバイナリデータから得られた回折パターンをプロットします。

---

### 1) プログラムの動作

`read_BRUKER_raw.py` は以下のステップで動作します。

1.  **入力ファイルの指定**:
    *   スクリプト内でデフォルトのテキストファイル名 (`.txt`) とバイナリファイル名 (`.raw`) が定義されています。
    *   コマンドライン引数でこれらのファイル名を上書きすることができます。最初の引数がテキストファイル、2番目の引数がバイナリファイルとして扱われます。
    *   指定されたファイル名がコンソールに出力されます。

2.  **テキストファイルの解析**:
    *   `analyze_RIGAKU` モジュール内の `parse_text_file` 関数を使用して、指定されたテキストファイルを読み込みます。
    *   この関数は、テキストファイルからメタデータ（`inf`）とX軸（`x_list`）、Y軸（`y_list`）の測定データを抽出します。
    *   抽出されたメタデータは `vars_text` ディクショナリに格納され、後でバイナリデータとの比較に使用されます。

3.  **バイナリファイルの解析**:
    *   `read_bin_file` 関数が呼び出され、指定されたバイナリファイルが読み込まれます。
    *   この関数は、`binparser` モジュール（`load_bin_file`, `get_data`, `type_map`）を利用してバイナリデータを解釈します。
    *   スクリプト内にハードコードされた `var_inf` リストは、バイナリファイル内の特定のオフセットにどのような種類の情報（変数名、データ型、オフセットなど）が格納されているかを定義します。このリストに基づいて、メタデータ（`vars_bin`）とX線回折パターンデータ（`x_list`, `y_list`）を抽出します。
    *   特に、X軸データの開始値（`Start`）、ステップサイズ（`Step`）、データポイント数（`ndata`）を抽出し、Y軸データ（`y[0]`, `y[1]`, ...）の開始オフセットとデータ型、サイズを特定します。
    *   これらの情報を用いて、全データポイントのX軸とY軸の値を計算し、`x_list` と `y_list` に格納します。

4.  **データ比較と表示**:
    *   テキストファイルとバイナリファイルから抽出されたメタデータ（`vars_text` と `vars_bin`）が比較され、コンソールに出力されます。同じ変数名を持つ項目については、両方のファイルからの値が並べて表示されます。

5.  **回折パターンのプロット**:
    *   `matplotlib.pyplot` を使用して、バイナリファイルから抽出されたX軸データ（`x_list`）とY軸データ（`y_list`）をプロットします。
    *   プロットのタイトルはバイナリファイル名となり、X軸ラベルは "2Theta"、Y軸ラベルは "Intensity" となります。
    *   生成されたグラフはGUIウィンドウとして表示されます。

### 2) 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは、以下の非標準ライブラリに依存しています。

*   **`chardet`**: ファイルのエンコーディングを自動検出するために使用されます。
*   **`matplotlib`**: データのプロット（グラフ表示）に使用されます。

また、以下のカスタムモジュールに依存しています。これらは、Pythonの標準ライブラリやpipでインストールできるものではなく、プログラムと同じディレクトリ、またはPythonの検索パスに存在する必要があります。

*   **`binparser.py`**: バイナリファイルを解析するためのカスタムモジュール。
*   **`analyze_RIGAKU.py`**: テキストファイルを解析するためのカスタムモジュール。

**非標準ライブラリのインストールコマンドとインストール方法**:

以下のコマンドをターミナルまたはコマンドプロンプトで実行してインストールします。

```bash
pip install chardet matplotlib
```

### 3) 必要な入力ファイル

プログラムの実行には、以下のファイルが必要です。

*   **X線回折のデータファイル（テキスト形式）**:
    *   デフォルト: `sk250606-2-Eagle-Bi5w-S150c50w-Sub200c-25min-oradw.txt`
    *   Rigaku製X線回折装置のデータ形式に準拠していると想定されます。
*   **X線回折の生データファイル（バイナリ形式）**:
    *   デフォルト: `sk250606-2-Eagle-Bi5w-S150c50w-Sub200c-25min-oradw.raw`
    *   Bruker製またはRigaku製X線回折装置の生データファイル形式に準拠していると想定されます。
*   **カスタムモジュール**:
    *   `binparser.py` (バイナリデータ解析用)
    *   `analyze_RIGAKU.py` (テキストデータ解析用)
    これらのPythonスクリプトは、`read_BRUKER_raw.py` と同じディレクトリに配置するか、Pythonのモジュール検索パスに追加されている必要があります。

### 4) 実行後に生成される出力ファイル

このプログラムは、ディスク上に新しいファイルを生成しません。
実行後の出力は以下の通りです。

*   **コンソール出力**: 入力ファイルのパス、解析されたメタデータ（テキストファイルとバイナリファイルからの比較結果）が表示されます。
*   **GUIウィンドウ**: `matplotlib` によって生成されたX線回折パターンのグラフが表示されます。

### 5) コマンドラインでの使用例 (Usage)

プログラムをコマンドラインから実行する方法は以下の通りです。

1.  **デフォルトのファイル名を使用する場合**:
    スクリプト内にハードコードされた`text_file`と`bin_file`が使用されます。

    ```bash
    python read_BRUKER_raw.py
    ```

2.  **カスタムのファイル名を指定する場合**:
    最初の引数でテキストファイル、2番目の引数でバイナリファイルを指定します。

    ```bash
    python read_BRUKER_raw.py <text_file_path> <raw_file_path>
    ```

    **例**:

    ```bash
    python read_BRUKER_raw.py my_xrd_data.txt my_xrd_data.raw
    ```