# pptx2txt_recursive.py Documentation

## 1) プログラムの動作
このプログラムは、指定されたディレクトリ内のすべてのPowerPoint（.pptx）ファイルを再帰的に検索し、それらのファイルからテキストを抽出して、指定された出力ファイルに書き込むものです。プログラムは、スライドのタイトルとテキストを抽出し、スライドごとに整理して出力します。また、ディレクトリの深さを制限するオプションも提供されています。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `python-pptx`

### インストールコマンド
```bash
pip install python-pptx
```

### インストール方法
1. コマンドラインを開きます。
2. 上記のインストールコマンドを入力して実行します。

## 3) 必要な入力ファイル
プログラムは、指定されたディレクトリ内のPowerPointファイル（.pptx）を入力ファイルとして使用します。デフォルトでは、現在のディレクトリ（`"."`）が検索対象となります。

## 4) 実行後に生成される出力ファイル
プログラムの実行後、テキストが抽出された内容は、指定された出力ファイル（デフォルトは `extracted_pptx_text.txt`）に保存されます。このファイルには、各スライドのタイトルとテキストが含まれます。

## 5) コマンドラインでの使用例 (Usage)
プログラムは、以下のコマンドライン引数を受け取ります。

```bash
python pptx2txt_recursive.py [root_dir] [output_path] [max_level]
```

- `root_dir` (オプション): 検索を開始するディレクトリのパス。デフォルトは現在のディレクトリ（`.`）。
- `output_path` (オプション): 抽出されたテキストを保存するファイルのパス。デフォルトは `extracted_pptx_text.txt`。
- `max_level` (オプション): 再帰的に検索するディレクトリの深さの制限。デフォルトは無制限（`-1`）。

### 使用例
```bash
python pptx2txt_recursive.py /path/to/directory output.txt 2
```
このコマンドは、`/path/to/directory` 内のすべての `.pptx` ファイルを検索し、テキストを `output.txt` に保存します。また、検索はディレクトリの深さが2までに制限されます。