# pptx2pdf_recursive.py Documentation

## 1. プログラムの動作
このプログラムは、指定されたディレクトリ内のすべてのPowerPoint（.pptx）ファイルを検索し、それらをPDF形式に変換します。変換は再帰的に行われ、サブディレクトリも含まれます。変換の際には、既存のPDFファイルが存在する場合、そのファイルの更新日時を確認し、元の.pptxファイルが新しい場合のみ再変換を行います。プログラムは、コマンドライン引数を通じてルートディレクトリと最大深さを指定できます。

## 2. 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを必要とします。

- **comtypes**

### インストールコマンド
```bash
pip install comtypes
```

### インストール方法
上記のコマンドをコマンドラインまたはターミナルで実行することで、`comtypes`ライブラリをインストールできます。

## 3. 必要な入力ファイル
プログラムは、指定されたディレクトリ内に存在するPowerPointファイル（拡張子が.pptxのファイル）を入力ファイルとして使用します。これらのファイルは、変換対象となります。

## 4. 実行後に生成される出力ファイル
プログラムが正常に実行されると、各PowerPointファイルに対して同名のPDFファイル（拡張子が.pdf）を生成します。PDFファイルは、元の.pptxファイルと同じディレクトリに保存されます。

## 5. コマンドラインでの使用例 (Usage)
プログラムは、以下のようにコマンドラインから実行できます。

```bash
python pptx2pdf_recursive.py [root_dir] [max_level]
```

### 引数
- `root_dir` (オプション): 検索を開始するルートディレクトリのパス。指定しない場合は、現在のディレクトリ（"."）が使用されます。
- `max_level` (オプション): 再帰的に検索する最大ディレクトリ深さ。指定しない場合は無制限（-1）となります。

### 使用例
1. 現在のディレクトリで.pptxファイルを変換する場合:
   ```bash
   python pptx2pdf_recursive.py
   ```

2. 特定のディレクトリ（例: `C:\Presentations`）で.pptxファイルを変換する場合:
   ```bash
   python pptx2pdf_recursive.py C:\Presentations
   ```

3. 最大深さを2に設定して変換する場合:
   ```bash
   python pptx2pdf_recursive.py C:\Presentations 2
   ``` 

このプログラムを使用することで、複数のPowerPointファイルを効率的にPDFに変換することができます。