# pptx2pdf.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、指定されたPowerPoint（.pptx）ファイルをPDF形式に変換します。コマンドライン引数として入力ファイルのパスを受け取り、オプションで出力ファイルのパスを指定することができます。出力ファイルのパスが指定されていない場合、プログラムは入力ファイル名に基づいて自動的に出力ファイル名を生成します。変換処理にはMicrosoft PowerPointのCOMオブジェクトを使用します。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは、以下の非標準ライブラリを必要とします。

- `comtypes`

### インストール方法
以下のコマンドを使用して、`comtypes`ライブラリをインストールします。

```bash
pip install comtypes
```

## 3) 必要な入力ファイル
プログラムは、変換対象のPowerPointファイル（.pptx形式）を入力ファイルとして必要とします。コマンドライン引数でこのファイルのパスを指定する必要があります。

## 4) 実行後に生成される出力ファイル
プログラムが正常に実行されると、指定された出力パスまたは自動生成されたパスにPDFファイルが作成されます。出力ファイルの拡張子は`.pdf`です。

## 5) コマンドラインでの使用例 (Usage)
プログラムは以下のようにコマンドラインから実行します。

```bash
python pptx2pdf.py <入力ファイルパス> [<出力ファイルパス>]
```

### 例
1. 入力ファイルのみ指定（出力ファイルは自動生成）:
   ```bash
   python pptx2pdf.py presentation.pptx
   ```

2. 入力ファイルと出力ファイルを指定:
   ```bash
   python pptx2pdf.py presentation.pptx output.pdf
   ```

プログラムの実行が完了すると、指定された出力ファイルにPDFが生成されます。