pptx2md.py は、PowerPoint (PPTX) ファイルからテキスト、数式、および画像を抽出し、それらを Markdown 形式で出力するPythonスクリプトです。

---

## 1) プログラムの動作

このプログラムは、指定されたPowerPointファイル（`.pptx`）を解析し、以下のコンテンツをMarkdownファイルに変換して出力します。

1.  **スライドタイトル:** 各スライドのタイトルプレースホルダー、または最初のテキストボックスの最初の行を抽出して見出しとして出力します。
2.  **テキスト:** スライド内のすべてのテキストボックスからテキストを抽出し、Markdownのセクションとして出力します。
3.  **数式:** PowerPointでMicrosoft Equation Editorなどを使用して作成された数式（OMML形式）を解析し、LaTeX形式のブロック数式（`$$ ... $$`）に変換して出力します。
    *   `\frac`, `\sqrt`, 上下付き文字、積分、総和などの一般的な数式表現に対応しています。
    *   Unicodeの数学記号（例: `∑`, `∫`, `α` など）は対応するLaTeXコマンドに変換されます。
    *   複数の行にわたる数式は、`\\` で区切られていれば、それぞれが独立したブロック数式として出力されます（Pandocなどのレンダリングに対応するため）。
    *   積分の微分記号 `d` は、`\\,\\mathrm{d}` に変換され、薄いスペースが挿入されます。
4.  **画像:** スライドに埋め込まれた画像を抽出し、指定されたディレクトリに保存し、Markdown形式の画像リンクとして出力します。

**内部処理の概要:**

1.  `argparse` を使用してコマンドライン引数を解析します。
2.  `python-pptx` ライブラリを使用して入力されたPPTXファイルを開き、各スライドを順に処理します。
3.  各スライドの生のXMLデータを `lxml` ライブラリでパースし、XPathクエリを用いてテキスト、数式、画像の要素を特定します。
4.  **テキスト:** `a:t` 要素からテキスト内容を抽出します。
5.  **数式:**
    *   `m:oMathPara` または `m:oMath` 要素をOMML数式ブロックとして特定します。
    *   `omml_to_latex()` 関数が再帰的にOMML XMLツリーを探索し、対応するLaTeX文字列を構築します。
    *   数式内のUnicode文字は `MATH_UNICODE_MAP` に基づいてLaTeXコマンドに置換されます。
    *   得られたLaTeX文字列は `split_latex_blocks()` 関数で `\\` （改行）で分割され、各行が `$$. .$$` で囲まれたブロック数式としてMarkdownに追加されます。
    *   `--xml` オプションが指定された場合、元のOMML XMLもMarkdownに出力されます。
6.  **画像:** `a:blip` 要素（埋め込み画像を表す）からリレーションシップIDを取得し、対応する画像データをPPTXファイルから抽出します。抽出された画像は指定された画像ディレクトリに保存され、そのパスを含むMarkdown画像構文 `![alt_text](path/to/image)` が生成されます。
7.  すべてのスライドの処理が完了した後、生成されたMarkdownコンテンツは指定された出力ファイルに書き込まれます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは、以下の非標準Pythonライブラリを使用します。

*   `python-pptx`: PowerPoint (.pptx) ファイルの読み書きを行うためのライブラリです。
*   `lxml`: 高速で強力なXML処理ライブラリで、PPTXファイル内のXML構造を解析するために使用されます。

**インストールコマンドとインストール方法:**

以下の `pip` コマンドを使用して、両方のライブラリをまとめてインストールできます。

```bash
pip install python-pptx lxml
```

**手順:**

1.  **Pythonとpipの確認:** Pythonがインストールされており、`pip` コマンドが利用可能であることを確認してください。ターミナルまたはコマンドプロンプトで `python --version` と `pip --version` を実行して確認できます。
2.  **インストールコマンドの実行:** 上記の `pip install` コマンドをターミナルまたはコマンドプロンプトで実行します。これにより、必要なライブラリとその依存関係が自動的にインストールされます。

## 3) 必要な入力ファイル

このプログラムの実行には、以下の入力ファイルが必要です。

*   **PowerPointプレゼンテーションファイル:** 拡張子が `.pptx` のファイル。
    *   このファイルは、コマンドライン引数で `-i` または `--input` オプションを使用して指定します。

**例:** `my_presentation.pptx`

## 4) 実行後に生成される出力ファイル

プログラムを実行すると、以下のファイルが生成されます。

*   **Markdownファイル:** 指定されたPPTXファイルから抽出されたテキスト、数式、画像リンクを含むMarkdown形式のファイル。
    *   このファイルは、コマンドライン引数で `-o` または `--output` オプションを使用して指定します。
    *   **例:** `output.md`

*   **画像ファイル:** PowerPointファイルから抽出されたすべての画像ファイル。
    *   これらの画像は、コマンドライン引数で `--imagedir` オプションで指定されたディレクトリ内に保存されます。デフォルトのディレクトリ名は `images` です。
    *   画像ファイル名は `slideX_imageY.ext` の形式になります（例: `slide1_image1.png`, `slide2_image1.jpeg`）。
    *   **例:** `images/slide1_image1.png`, `images/slide1_image2.jpeg`

## 5) コマンドラインでの使用例 (Usage)

`pptx2md.py` スクリプトは、以下のコマンドライン引数を受け入れます。

*   `-i`, `--input <FILE>`: (必須) 入力するPowerPointファイル名。
*   `-o`, `--output <FILE>`: (必須) 出力するMarkdownファイル名。
*   `--xml`: (オプション) 数式の元のOMML XMLをMarkdownに出力します。
*   `--imagedir <DIR>`: (オプション) 画像ファイルを保存するディレクトリ。デフォルトは `images` です。

---

### 基本的な使用例

入力ファイル `presentation.pptx` からコンテンツを抽出し、`output.md` というMarkdownファイルを生成します。画像はデフォルトで `images` ディレクトリに保存されます。

```bash
python pptx2md.py -i presentation.pptx -o output.md
```

### 画像ディレクトリを指定する例

入力ファイル `report.pptx` からコンテンツを抽出し、`report_notes.md` を生成します。画像は `report_assets` という新しいディレクトリに保存されます。

```bash
python pptx2md.py -i report.pptx -o report_notes.md --imagedir report_assets
```

### 元のOMML XMLを含める例

入力ファイル `lecture.pptx` からコンテンツを抽出し、`lecture_notes.md` を生成します。数式の変換元となったOMML XMLもMarkdownファイルに含めます。

```bash
python pptx2md.py -i lecture.pptx -o lecture_notes.md --xml
```

### すべてのオプションを使用する例

入力ファイル `slides.pptx` からコンテンツを抽出し、`notes.md` を生成します。画像は `slide_images` ディレクトリに保存され、OMML XMLもMarkdownに含めます。

```bash
python pptx2md.py -i slides.pptx -o notes.md --imagedir slide_images --xml
```