# pptx2img.py Documentation

## 1) プログラムの動作
このプログラムは、指定されたPowerPoint（PPTX）ファイルを画像ファイル（PNGまたはJPG形式）にエクスポートするためのスクリプトです。プログラムは、PowerPointアプリケーションをCOMオブジェクトとして操作し、スライドを画像として保存します。エクスポートされた画像ファイルの名前は、デフォルトの「スライドN.png」から「slideN.png」に変更されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `comtypes`

### インストールコマンド
```bash
pip install comtypes
```

### インストール方法
上記のコマンドをコマンドラインまたはターミナルで実行することで、`comtypes`ライブラリをインストールできます。

## 3) 必要な入力ファイル
プログラムを実行するには、エクスポートしたいPowerPointファイル（.pptx形式）が必要です。デフォルトでは、`41-01-search_MP.pptx`というファイルが指定されていますが、コマンドライン引数を使用して他のファイルを指定することもできます。

## 4) 実行後に生成される出力ファイル
プログラムが正常に実行されると、指定された出力ディレクトリにエクスポートされた画像ファイルが生成されます。画像ファイルの形式は、コマンドライン引数で指定された形式（デフォルトはPNG）になります。ファイル名は「slideN.png」という形式になります。

## 5) コマンドラインでの使用例 (Usage)
以下は、プログラムをコマンドラインから実行するための使用例です。

```bash
python pptx2img.py [input_file] [output_directory] [image_format]
```

### 引数の説明
- `input_file`（オプション）: エクスポートするPowerPointファイルのパス（デフォルトは`41-01-search_MP.pptx`）。
- `output_directory`（オプション）: 画像を保存するディレクトリのパス（デフォルトは`images`）。
- `image_format`（オプション）: エクスポートする画像の形式（例: `png`, `jpg`、デフォルトは`png`）。

### 使用例
```bash
python pptx2img.py my_presentation.pptx output_images jpg
```

このコマンドは、`my_presentation.pptx`を`output_images`ディレクトリにJPG形式でエクスポートします。