# pptx2html_recursive.py Documentation

## 1. プログラムの動作
このプログラムは、指定されたディレクトリ内のPowerPoint（.pptx）ファイルからテキストを抽出し、検索可能なHTMLファイルを生成します。抽出されたテキストは、スライドごとに整理され、各スライドのタイトルと内容が表示されます。ユーザーはHTMLページ内でテキストを検索することができ、検索結果はハイライト表示されます。

## 2. 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `python-pptx`: PowerPointファイルを操作するためのライブラリ。

### インストールコマンド
```bash
pip install python-pptx
```

### インストール方法
1. Pythonがインストールされていることを確認します。
2. 上記のコマンドをターミナルまたはコマンドプロンプトで実行します。

## 3. 必要な入力ファイル
プログラムは、指定されたディレクトリ内のPowerPointファイル（.pptx）を入力として使用します。デフォルトでは、現在のディレクトリ（`"."`）が使用されます。

## 4. 実行後に生成される出力ファイル
プログラムの実行後、指定された出力パスにHTMLファイルが生成されます。デフォルトの出力ファイル名は `extracted_pptx_text.html` です。このHTMLファイルには、抽出されたテキストが含まれ、検索機能が実装されています。

## 5. コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行できます。

```bash
python pptx2html_recursive.py [root_dir] [output_path] [max_level] [extract_mode]
```

### 引数
- `root_dir`: 検索するディレクトリのパス（デフォルトは現在のディレクトリ）。
- `output_path`: 出力するHTMLファイルのパス（デフォルトは `extracted_pptx_text.html`）。
- `max_level`: サブディレクトリの探索レベル（デフォルトは無制限、-1）。
- `extract_mode`: テキストの抽出モード（`"paragraph"` または `"run"`、デフォルトは `"paragraph"`）。

### 使用例
```bash
python pptx2html_recursive.py ./presentations output.html 2 paragraph
```
このコマンドは、`./presentations` ディレクトリ内のPowerPointファイルを探索し、最大2レベルのサブディレクトリを検索し、抽出したテキストを `output.html` に保存します。テキストは段落単位で抽出されます。