# PDF to Markdown Converter Documentation

## 1) プログラムの動作
このプログラムは、指定されたPDFファイルをMarkdown形式に変換します。変換されたMarkdownファイルには、PDFの各ページがH2見出しとして記載され、ページの内容がその下にテキストとして書き込まれます。ページ間には区切り線が追加されます。出力ファイル名は、入力ファイル名に基づいて自動的に生成されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `pdfplumber`

### インストールコマンド
```bash
pip install pdfplumber
```

### インストール方法
1. 上記のコマンドをターミナルまたはコマンドプロンプトに入力して実行します。
2. インストールが完了したら、プログラムを実行できます。

## 3) 必要な入力ファイル
- PDFファイル: 変換したいPDFファイルのパスを指定する必要があります。コマンドライン引数`--infile`で指定します。

## 4) 実行後に生成される出力ファイル
- Markdownファイル: 指定されたPDFファイルを変換した結果がMarkdown形式で保存されます。出力ファイル名は、入力ファイル名から拡張子を除いたものに`.md`を付加したものになります。出力ファイルのパスは、コマンドライン引数`--outfile`で指定できますが、指定しない場合は自動的に生成されます。

## 5) コマンドラインでの使用例 (Usage)
以下は、プログラムをコマンドラインから実行する例です。

```bash
python pdf2md.py --infile path/to/input.pdf --outfile path/to/output.md
```

### 引数の説明
- `--infile`: 変換するPDFファイルのパスを指定します。
- `--outfile`: 出力するMarkdownファイルのパスを指定します（省略可能）。指定しない場合は、入力ファイル名に基づいて自動的に生成されます。

### 例
```bash
python pdf2md.py --infile example.pdf
```
このコマンドは、`example.pdf`を変換し、同じディレクトリに`example.md`という名前のMarkdownファイルを生成します。