import os
import sys
import fitz  # PyMuPDF


pdf_path = 'test.pdf'
output_path = 'test.png'
first_page_only = True

argv = sys.argv
narg = len(argv)
if narg > 1:
    pdf_path = argv[1]
if narg > 2:
    output_path = argv[2]
if narg > 3:
    first_page_only = int(argv[3])

pdf_document = fitz.open(pdf_path)

if first_page_only:
    print(f"save to {output_path}")
    page = pdf_document.load_page(0)
    pix = page.get_pixmap()
    pix.save(output_path)
else:
    for page_num in range(len(pdf_document)):
        page = pdf_document.load_page(page_num)
        pix = page.get_pixmap() 
        output_path = os.path.join(output_dir, f'page_{page_num + 1}.png')
        print(f"save to {output_path}")
        pix.save(output_path)
