# プログラムドキュメント: pdf2img1.py

## 1) プログラムの動作
このプログラムは、指定されたPDFファイルを画像ファイル（PNG形式）に変換するツールです。デフォルトでは、最初のページのみを変換しますが、オプションを指定することで全ページを変換することも可能です。変換された画像は指定された出力パスに保存されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- **PyMuPDF** (fitz)

### インストールコマンド
```bash
pip install PyMuPDF
```

### インストール方法
1. Pythonがインストールされていることを確認します。
2. コマンドラインを開き、上記のインストールコマンドを入力して実行します。

## 3) 必要な入力ファイル
- **PDFファイル**: 変換したいPDFファイルのパス（デフォルトは `test.pdf`）。

## 4) 実行後に生成される出力ファイル
- **PNGファイル**: 変換された画像ファイル。デフォルトでは `test.png` という名前で保存されます。全ページを変換する場合は、`page_1.png`, `page_2.png`, ... のようにページ番号が付与されたファイル名で保存されます。

## 5) コマンドラインでの使用例 (Usage)
以下のコマンドを使用してプログラムを実行できます。

```bash
python pdf2img1.py [PDFファイルのパス] [出力ファイルのパス] [最初のページのみを変換するか (0または1)]
```

### 使用例
1. 最初のページのみを変換する場合（デフォルトの設定）:
   ```bash
   python pdf2img1.py
   ```

2. 特定のPDFファイルを指定し、出力ファイル名を変更する場合:
   ```bash
   python pdf2img1.py my_document.pdf output_image.png
   ```

3. 全ページを変換する場合:
   ```bash
   python pdf2img1.py my_document.pdf output_image.png 0
   ``` 

このプログラムを使用することで、PDFファイルを簡単に画像形式に変換することができます。