import os
import sys
try:
    import fitz  # PyMuPDF
except:
    print("\npptx2pdf_recursive.py: Import error: fitz")
    input("Install: pip install pymupdf\n")


infile = 'output.pdf'
out_dir = 'images'
image_format = 'png'


nargv = len(sys.argv)
if nargv >= 2: infile = sys.argv[1]
if nargv >= 3: out_dir = sys.argv[2]
if nargv >= 4: image_format = sys.argv[3]


def convert_pdf_to_images(pdf_file, out_dir, image_format):
    print(f"Input file: [{pdf_file}]")
    print(f"Output dir: [{out_dir}]")
    print(f"Output format: [{image_format}]")
     
     
    if not os.path.exists(out_dir):
        print(f"Create [{out_dir}]")
        os.makedirs(out_dir)

    print(f"Open [{pdf_file}]")
    doc = fitz.open(pdf_file)
    print(f"Exporting as images [{image_format}] to [{out_dir}]")
    for page_num in range(len(doc)):
        page = doc.load_page(page_num)
        pix = page.get_pixmap()
        output_path = os.path.join(out_dir, f'page_{page_num + 1}.{image_format}')
        pix.save(output_path)

if __name__ == '__main__':
    current_dir = os.getcwd()
    pdf_path = os.path.join(current_dir, pdf_file)

    convert_pdf_to_images(pdf_path, out_dir, image_format)
