# PDF to Image Converter Documentation

## 1) プログラムの動作
このプログラムは、指定されたPDFファイルを画像ファイルに変換するためのスクリプトです。デフォルトでは、`output.pdf`というPDFファイルを読み込み、`images`というディレクトリにPNG形式で画像を出力します。コマンドライン引数を使用することで、入力ファイル名、出力ディレクトリ、出力画像形式を変更することができます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、`PyMuPDF`ライブラリ（`fitz`モジュール）を使用しています。以下のコマンドでインストールできます。

```bash
pip install pymupdf
```

## 3) 必要な入力ファイル
プログラムは、PDFファイルを入力として受け取ります。デフォルトでは、`output.pdf`という名前のファイルを期待しています。コマンドライン引数を使用することで、他のPDFファイルを指定することも可能です。

## 4) 実行後に生成される出力ファイル
プログラムは、指定された出力ディレクトリにPDFの各ページを画像ファイルとして保存します。デフォルトでは、`images`というディレクトリに、各ページが`page_1.png`, `page_2.png`, ...の形式で保存されます。出力画像の形式は、コマンドライン引数で指定することができます（デフォルトはPNG形式）。

## 5) コマンドラインでの使用例 (Usage)
以下は、コマンドラインでの使用例です。

```bash
python pdf2img.py [input_pdf] [output_directory] [image_format]
```

- `input_pdf`: 変換したいPDFファイルのパス（デフォルトは`output.pdf`）
- `output_directory`: 画像を保存するディレクトリ（デフォルトは`images`）
- `image_format`: 出力画像の形式（例: `png`, `jpg`など、デフォルトは`png`）

### 例
1. デフォルト設定で実行する場合:
   ```bash
   python pdf2img.py
   ```

2. 特定のPDFファイルを指定する場合:
   ```bash
   python pdf2img.py my_document.pdf
   ```

3. 出力ディレクトリと画像形式を指定する場合:
   ```bash
   python pdf2img.py my_document.pdf output_images jpg
   ```