# Office File Converter Documentation

## 1. プログラムの動作
このプログラムは、PowerPoint（.pptx）、Word（.docx）、PDF（.pdf）ファイルを指定されたフォーマット（PNG、PDF、Markdown）に変換するためのコマンドラインツールです。ユーザーは入力ファイル、出力ディレクトリ、および出力フォーマットを指定できます。プログラムは、入力ファイルの拡張子に基づいて適切な変換処理を実行します。

## 2. 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています。これらは、Pythonのパッケージ管理ツールである`pip`を使用してインストールできます。

```bash
pip install convert2md pptx2pdf pptx2img pptx2md docx2img pdf2img pdf2md img2pdf
```

## 3. 必要な入力ファイル
プログラムは以下のいずれかの形式の入力ファイルを必要とします：
- PowerPointファイル（.pptx）
- Wordファイル（.docx）
- PDFファイル（.pdf）
- 画像ファイル（.jpeg, .jpg, .png）

デフォルトの入力ファイルは`41-01-search_MP.pptx`です。

## 4. 実行後に生成される出力ファイル
出力ファイルは指定されたフォーマットに応じて生成されます。出力フォーマットは以下のいずれかです：
- PNG画像（指定された出力ディレクトリに保存）
- PDFファイル（指定された出力ディレクトリに保存）
- Markdownファイル（指定された出力ディレクトリに保存）

出力ディレクトリはデフォルトで`images`に設定されています。

## 5. コマンドラインでの使用例 (Usage)
以下は、コマンドラインでのプログラムの使用例です。

```bash
python office_file_converter.py --infile <入力ファイルのパス> --output_dir <出力ディレクトリのパス> --output_format <出力フォーマット>
```

### 例
1. PowerPointファイルをPNG形式で変換する場合：
   ```bash
   python office_file_converter.py --infile example.pptx --output_format png
   ```

2. WordファイルをPDF形式で変換する場合：
   ```bash
   python office_file_converter.py --infile example.docx --output_format pdf
   ```

3. PDFファイルをMarkdown形式で変換する場合：
   ```bash
   python office_file_converter.py --infile example.pdf --output_format md
   ```

デフォルトの入力ファイルや出力ディレクトリを使用する場合、引数を省略することもできます。