# merge_pdf.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、指定されたディレクトリ内のPDFファイルを連結またはリネームするためのツールです。主な機能は以下の通りです：

- **PDFの連結**: 指定された数のPDFファイルを一つのPDFに連結し、連結されたファイルの先頭ページに元のファイル名を記載します。連結に失敗したファイルは、元のまま別のディレクトリにコピーされます。
- **PDFのリネーム**: PDFファイル名の先頭に4桁の連番を付けてリネームします。既存の連番がある場合は、その最大数の次から連番を付けます。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用します：

- **PyPDF2**: PDFファイルの操作を行うためのライブラリ。
- **reportlab**: PDFファイルの生成を行うためのライブラリ。

### インストールコマンド
```bash
pip install PyPDF2 reportlab
```

## 3) 必要な入力ファイル
プログラムを実行するには、指定された作業ディレクトリ（`work_dir`）内に連結またはリネームしたいPDFファイルが必要です。これらのファイルは、`.pdf`拡張子を持つ必要があります。

## 4) 実行後に生成される出力ファイル
- **連結モード**: 指定された数のPDFファイルを連結した新しいPDFファイルが、`merged`というサブディレクトリに保存されます。ファイル名は`merged_001.pdf`のように連番が付与されます。
- **リネームモード**: 指定されたディレクトリ内のPDFファイルが、4桁の連番を付けてリネームされます。

## 5) コマンドラインでの使用例 (Usage)
以下は、プログラムのコマンドラインでの使用例です。

### PDFの連結
```bash
python merge_pdf.py /path/to/pdf/directory -n 5 --mode merge
```
- `/path/to/pdf/directory`: PDFファイルが格納されているディレクトリのパス。
- `-n 5`: 一度に連結するPDFファイルの数（この例では5）。
- `--mode merge`: PDFの連結モードを指定。

### PDFのリネーム
```bash
python merge_pdf.py /path/to/pdf/directory --mode rename
```
- `/path/to/pdf/directory`: PDFファイルが格納されているディレクトリのパス。
- `--mode rename`: PDFのリネームモードを指定。

### デフォルトの使用
```bash
python merge_pdf.py
```
- デフォルトでは、カレントディレクトリ（`.`）内のPDFファイルを連結し、最大10ファイルを一度に処理します。