# merge_office_files.py Documentation

## 1. プログラムの動作
このプログラムは、指定されたディレクトリ内のPDF、Word（.docx）、およびPowerPoint（.pptx）ファイルを連結またはリネームするためのツールです。主な機能は以下の通りです：

- **マージモード**: 指定された数のファイルを連結し、`merged`というサブディレクトリに保存します。連結する際、各ファイルの名前を示すページを追加し、読み込みに失敗したファイルはそのまま`merged`ディレクトリにコピーされます。
- **リネームモード**: 指定されたファイルタイプのファイル名に4桁の連番を付けてリネームします。

プログラムはコマンドライン引数を使用して動作します。

## 2. 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています：

- `PyPDF2`
- `python-docx`
- `python-pptx`
- `reportlab`

これらのライブラリは、以下のコマンドでインストールできます：

```bash
pip install PyPDF2 python-docx python-pptx reportlab
```

## 3. 必要な入力ファイル
プログラムは、指定された`work_dir`ディレクトリ内に以下のファイルタイプを検索します：

- PDFファイル（*.pdf）
- Wordファイル（*.docx）
- PowerPointファイル（*.pptx）

## 4. 実行後に生成される出力ファイル
プログラムの実行後、以下の出力ファイルが生成されます：

- `merged`ディレクトリ内に、連結されたPDFファイル（`merged_001.pdf`, `merged_002.pdf`など）や、リネームされたファイルが保存されます。
- 各連結されたPDFには、連結されたファイルの名前を示すページが含まれます。

## 5. コマンドラインでの使用例 (Usage)
プログラムは以下のようにコマンドラインから実行できます：

```bash
python merge_office_files.py [work_dir] [-n nmerge] [-m mode] [-t filetype] [--max_depth max_depth]
```

### 引数の説明
- `work_dir`: 対象ファイルを検索するディレクトリ。デフォルトはカレントディレクトリ（`.`）。
- `-n`, `--nmerge`: 連結するファイルの数。デフォルトは10。
- `-m`, `--mode`: 実行モードを選択します。`merge`（デフォルト）または`rename`。
- `-t`, `--filetype`: 処理するファイルタイプ。`pdf`（デフォルト）、`docx`、`pptx`。
- `--max_depth`: 検索するディレクトリの深さを制限します。デフォルトは0。

### 使用例
1. PDFファイルを10個ずつ連結する場合：
   ```bash
   python merge_office_files.py ./ -n 10 -m merge -t pdf
   ```

2. Wordファイルをリネームする場合：
   ```bash
   python merge_office_files.py ./ -m rename -t docx
   ```

3. PowerPointファイルを連結する場合：
   ```bash
   python merge_office_files.py ./ -m merge -t pptx
   ``` 

このプログラムを使用することで、複数のオフィスファイルを効率的に管理できます。