import os
import sys
from pptx import Presentation

# 入力ファイル名
infile = "input.md"

if len(sys.argv) >= 1: infile = sys.argv[1]


# 出力ファイル名を設定（拡張子を .pptx に変更）
outfile = os.path.splitext(infile)[0] + ".pptx"

# PowerPointプレゼンテーションの初期化
presentation = Presentation()

# Markdownファイルを読み込む
with open(infile, "r", encoding="utf-8") as f:
    lines = f.readlines()

# スライド作成
current_slide = None
content = ""  # スライド内のテキストをまとめる変数
for line in lines:
    # 新しいスライドの開始を判定
    if line.startswith("# ") or line.startswith("## "):
        # 前のスライドの内容を既存の箇条書きに追加
        if current_slide and content.strip():
            text_frame = current_slide.placeholders[1].text_frame
            for paragraph in content.strip().split("\n"):
                text_frame.add_paragraph().text = paragraph.strip()
        # 新しいスライドを作成
        current_slide = presentation.slides.add_slide(presentation.slide_layouts[1])  # レイアウト: タイトルとコンテンツ
#        slide_title = line.replace("## スライド", "").strip()  # スライド番号をタイトルに
        slide_title = line.replace("# ", "").replace("## ", "").strip()  # スライド番号をタイトルに
        current_slide.shapes.title.text = f"スライド {slide_title}"  # タイトル設定
        content = ""  # コンテンツをリセット
    elif current_slide:  # 同じスライドにコンテンツを追加
        content += line.strip() + "\n"

# 最後のスライドに残った内容を既存の箇条書きに追加
if current_slide and content.strip():
    text_frame = current_slide.placeholders[1].text_frame
    for paragraph in content.strip().split("\n"):
        text_frame.add_paragraph().text = paragraph.strip()

# PowerPointファイルを保存
presentation.save(outfile)

print(f"MarkdownファイルをPowerPointファイルに変換しました: {outfile}")
