以下は、md2pptx.py の動作を整理したドキュメントです。

# 1) プログラムの動作

- デフォルトの入力ファイル名は input.md。実行時にコマンドライン引数として別のファイル名を渡すと、そのファイルを入力として使用します。
- 入力ファイル名の拡張子を .pptx に変更したファイル名を出力ファイル名として作成します（例: input.md → input.pptx）。
- PowerPoint プレゼンテーションを新規作成します。
- Markdown ファイルを行単位で読み込み、以下のルールでスライドを作成します。
  - 行が「# 」または「## 」で始まる場合、その行は新しいスライドの開始を示します。
    - その前のスライドが存在し、かつ前段のコンテンツが空でない場合、現在のスライドの箇条書きエリア（プレースホルダ 1）に content の内容を段落として追加します。
    - 新しいスライドを追加し、タイトルをこの行から「スライド <タイトル>」として設定します（行の先頭の「# 」や「## 」を削除してタイトル化）。
    - content をリセットします。
  - 上記の新しいスライド開始行ではない場合は、現在のスライドが存在すれば、その行を content に追加します（行末改行を挟んで連結）。
- ループ終了後、最後のスライドに残っている content があれば、それを箇条書きとして追加します。
- 最後に PowerPoint ファイルを保存します。
- コンソールへ、出力ファイル名を含む完了メッセージを表示します。

注意点:
- 現在の実装では、コマンドライン引数の扱いに若干の不具合がある可能性があります。具体的には、入力ファイル名を取得する条件が if len(sys.argv) >= 1: infile = sys.argv[1] となっており、コマンド実行時に引数を渡さなかった場合に IndexError が発生する可能性があります。実際にはスクリプト名のみの実行時にはエラーになります。

# 2) 必要な非標準ライブラリとインストール方法

- 必要な非標準ライブラリ（外部ライブラリ）:
  - python-pptx

- インストール方法:
  - pip を使用してインストールします。
  - コマンド例:
    - pip install python-pptx

- 補足:
  - このライブラリは PowerPoint (.pptx) ファイルの作成・編集機能を提供します。
  - Python の実行環境は Python 3.x を推奨します。

# 3) 必要な入力ファイル

- input.md（デフォルトファイル名）
  - Markdown 形式のテキストファイル。スライドの開始を示すのは以下のヘッダ行です:
    - # で始まる行（例: "# タイトル"）
    - ## で始まる行（例: "## サブタイトル"）
  - それ以外の行は、現在のスライドの本文内容として追加されます。
  - 文字コードは UTF-8 を想定しています。

- 入力ファイルの例構成:
  - # スライド1
  - 内容の行1
  - 内容の行2
  - ## スライド2
  - 内容の行A
  - 内容の行B

# 4) 実行後に生成される出力ファイル

- 出力ファイル名は入力ファイル名の拡張子を .pptx に変更したものになります。
  - 例: input.md → input.pptx
- 出力ファイル中の各スライドは以下のように構成されます:
  - スライドのタイトル: 「スライド <ヘッダ行のテキスト>」として設定（ヘッダ行から「# 」または「## 」を除去）
  - スライド本文: ヘッダ行以降、同じスライドに対応する content の各行を個別の段落として追加

# 5) コマンドラインでの使用例 (Usage)

- 基本的な使い方（入力ファイルをデフォルトの input.md として実行）:
  - python md2pptx.py
  - なお、この場合はエラーになる可能性があります（引数が不足しているため）。実運用では必ず入力ファイル名を渡してください。

- 入力ファイルを指定して実行:
  - python md2pptx.py input.md

- 出力ファイル例:
  - input.pptx（同じディレクトリに作成）

- 補足情報:
  - スクリプトを実行する前に、前述の python-pptx ライブラリがインストールされていることを確認してください。
  - 入力ファイルの文字コードは UTF-8 を前提としているため、他の文字コードを使用する場合は適宜変換してください。

もし、引数の扱いを修正して「引数が1個以上ある場合のみ infile に sys.argv[1] を設定、それ以外はデフォルトの input.md のまま」という挙動にしたい場合や、初回スライドのタイトル設定方法を改善したい場合には、その点も対応案をご提案できます。