# md2docx.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、Markdown形式のテキストファイル（`input.md`）を読み込み、Microsoft Word形式のドキュメント（`.docx`）に変換します。プログラムは、Markdownの見出しや箇条書き、通常の段落を認識し、それに応じたWord文書の構造を作成します。最終的に、変換されたWordファイルは、元のMarkdownファイル名を基にした名前で保存されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `python-docx`

### インストールコマンド
```bash
pip install python-docx
```

### インストール方法
1. Pythonがインストールされていることを確認します。
2. コマンドラインまたはターミナルを開きます。
3. 上記のインストールコマンドを入力して実行します。

## 3) 必要な入力ファイル
プログラムは、`input.md`という名前のMarkdownファイルを必要とします。このファイルには、Markdown形式で書かれたテキストが含まれている必要があります。

## 4) 実行後に生成される出力ファイル
プログラムを実行すると、`input.md`と同じディレクトリに、`input.docx`という名前のMicrosoft Wordファイルが生成されます。このファイルには、Markdownの内容がWord形式に変換されたものが含まれます。

## 5) コマンドラインでの使用例 (Usage)
プログラムを実行するには、以下の手順を行います。

1. `md2docx.py`を含むディレクトリに移動します。
2. コマンドラインまたはターミナルで以下のコマンドを実行します。

```bash
python md2docx.py
```

このコマンドを実行すると、`input.md`が読み込まれ、変換された`input.docx`が生成されます。