#pip install Pillow

import os
import argparse
try:
    from PIL import Image
except:
    print("\npptx2pdf_recursive.py: Import error: dotenv")
    input("Install: pip install Pillow\n")


def initialize():
    parser = argparse.ArgumentParser(description='画像ファイルをPDFに変換するプログラム')
    parser.add_argument(
        'input_file', 
        type=str, 
        help='PDFに変換したい画像ファイルのパス'
    )
    return parser

def convert_image_to_pdf(input_path):
    """
    指定された画像ファイルをPDFに変換します。
    PDFのファイル名は、入力ファイルの拡張子を .pdf に変更したものです。

    Args:
        input_path (str): 変換したい画像ファイルのパス。
    """
    if not os.path.exists(input_path):
        print(f"エラー: 指定されたファイルが見つかりません -> '{input_path}'")
        return

    try:
        image = Image.open(input_path)

        base_name, _ = os.path.splitext(input_path)
        output_path = base_name + '.pdf'
        print(f"入力ファイル: {input_path}")
        print(f"  出力ファイル: {output_path}")

        image.save(output_path, "PDF", resolution=100.0, save_all=True)
        print(f"  変換が完了しました。")
    except Exception as e:
        print(f"  変換中にエラーが発生しました: {e}")
        print("  サポートされていない画像形式か、ファイルが破損している可能性があります。")
        return False

    return True

def main():
    parser = initialize()
    args = parser.parse_args()

    files = sorted(glob.glob(args.input_file))
    print()
    print("Files found for [{args.input_file}]")
    for f in files:
        print(f"  {f}")

    for f in files:
        print()
        convert_image_to_pdf(args.input_file)

    input("\nPress ENTER to terminate>>\n")
    

if __name__ == "__main__":
    main()
