# img2pdf.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、指定された画像ファイルをPDF形式に変換するためのスクリプトです。ユーザーが指定した画像ファイルのパスを受け取り、そのファイルをPDFに変換します。変換後のPDFファイルは、元の画像ファイル名の拡張子を`.pdf`に変更した名前で保存されます。プログラムは、指定されたファイルが存在しない場合や、変換中にエラーが発生した場合に適切なエラーメッセージを表示します。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは、以下の非標準ライブラリを使用しています。

- **Pillow**: 画像処理ライブラリ

### インストールコマンド
```bash
pip install Pillow
```

### インストール方法
1. コマンドラインを開きます。
2. 上記のインストールコマンドを入力して実行します。

## 3) 必要な入力ファイル
プログラムは、変換したい画像ファイルのパスを引数として受け取ります。サポートされている画像形式は、Pillowライブラリが対応している形式（JPEG, PNG, BMP, GIFなど）です。

## 4) 実行後に生成される出力ファイル
プログラムが正常に実行されると、指定された画像ファイルと同じディレクトリに、同名のPDFファイルが生成されます。PDFファイルの拡張子は`.pdf`です。

## 5) コマンドラインでの使用例 (Usage)
以下のコマンドを使用してプログラムを実行します。

```bash
python img2pdf.py <画像ファイルのパス>
```

### 使用例
```bash
python img2pdf.py example_image.jpg
```

このコマンドを実行すると、`example_image.jpg`がPDFに変換され、`example_image.pdf`というファイルが生成されます。