# HTML to PDF Converter Documentation

## 1. プログラムの動作
このプログラムは、指定されたHTMLファイルをPDF形式に変換するためのスクリプトです。コマンドライン引数として入力ファイルのパスと出力ファイルのパスを受け取り、指定されたHTMLファイルをPDFに変換します。変換には、`weasyprint`または`pdfkit`ライブラリを使用します。どちらのライブラリも利用できない場合は、エラーメッセージを表示します。

## 2. 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用します。

- **WeasyPrint**
  - インストールコマンド: 
    ```bash
    pip install weasyprint
    ```
  
- **pdfkit**
  - インストールコマンド: 
    ```bash
    pip install pdfkit
    ```
  - さらに、`wkhtmltopdf`をインストールする必要があります。以下のリンクからダウンロードしてインストールしてください:
  - [wkhtmltopdfのダウンロードページ](https://wkhtmltopdf.org/)

## 3. 必要な入力ファイル
プログラムは、HTML形式のファイルを入力として受け取ります。デフォルトでは、`peak_fit.html`というファイルが使用されますが、コマンドライン引数として別のファイルを指定することもできます。

## 4. 実行後に生成される出力ファイル
プログラムの実行後、指定された出力パスにPDFファイルが生成されます。出力パスが指定されていない場合、入力ファイル名に基づいて同名のPDFファイルが生成されます（拡張子は`.pdf`に変更されます）。

## 5. コマンドラインでの使用例 (Usage)
以下は、コマンドラインでの使用例です。

```bash
python html2pdf.py [input_file.html] [output_file.pdf]
```

- `input_file.html`: 変換したいHTMLファイルのパス（省略可能、デフォルトは`peak_fit.html`）。
- `output_file.pdf`: 生成されるPDFファイルのパス（省略可能、指定しない場合は入力ファイル名に基づいて生成される）。

### 例
1. デフォルトのHTMLファイルをPDFに変換する場合:
   ```bash
   python html2pdf.py
   ```

2. 特定のHTMLファイルをPDFに変換する場合:
   ```bash
   python html2pdf.py myfile.html
   ```

3. 特定のHTMLファイルを指定した名前のPDFに変換する場合:
   ```bash
   python html2pdf.py myfile.html output.pdf
   ```