# docx2pdf_recursive.py Documentation

## 1. プログラムの動作
このプログラムは、指定されたディレクトリ内のすべての `.docx` ファイルを再帰的に検索し、PDF形式に変換します。変換はMicrosoft Wordを使用して行われ、既にPDFファイルが存在する場合は、元のWordファイルが更新されているかどうかを確認し、必要に応じて再変換を行います。プログラムは、コマンドライン引数を通じて検索するディレクトリと再帰の深さを指定できます。

## 2. 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを必要とします。

- `comtypes`

### インストールコマンド
```bash
pip install comtypes
```

### インストール方法
上記のコマンドをコマンドラインまたはターミナルで実行してください。これにより、`comtypes`ライブラリがインストールされます。

## 3. 必要な入力ファイル
プログラムは、指定されたディレクトリ内に存在する `.docx` ファイルを入力ファイルとして使用します。これらのファイルは、Microsoft Word形式の文書である必要があります。

## 4. 実行後に生成される出力ファイル
プログラムは、各 `.docx` ファイルに対して同名の `.pdf` ファイルを生成します。出力ファイルは、元のWordファイルと同じディレクトリに保存されます。

## 5. コマンドラインでの使用例 (Usage)
プログラムは、以下のようにコマンドラインから実行できます。

```bash
python docx2pdf_recursive.py [root_dir] [max_level]
```

### 引数
- `root_dir` (オプション): 検索を開始するディレクトリのパス。指定しない場合は、現在のディレクトリが使用されます。
- `max_level` (オプション): 再帰的に検索する深さの制限。指定しない場合は無制限（-1）となります。

### 使用例
1. 現在のディレクトリ内のすべての `.docx` ファイルを変換する場合:
   ```bash
   python docx2pdf_recursive.py
   ```

2. 特定のディレクトリ（例: `documents`）内のファイルを変換する場合:
   ```bash
   python docx2pdf_recursive.py documents
   ```

3. 最大深さを3に設定して変換する場合:
   ```bash
   python docx2pdf_recursive.py documents 3
   ``` 

このプログラムを使用することで、Word文書を効率的にPDF形式に変換することができます。