import os
import sys
import comtypes.client
try:
    import fitz  # PyMuPDF
except:
    print("\npptx2pdf_recursive.py: Import error: fitz")
    input("Install: pip install pymupdf\n")


# 入力ファイルと出力ディレクトリの設定
infile = '20240815-Coverletter.docx'
pdf_file = 'output.pdf'
out_dir = 'images_doc'

import os
import comtypes.client

def convert_word_to_pdf(word_file, pdf_file):
    print(f"Convert [{word_file}] to [{pdf_file}]")
    application = None  # 初期化
    doc = None          # 初期化
    try:
        application = comtypes.client.CreateObject('Word.Application')
        application.Visible = False # Wordのウィンドウを非表示にする（任意）
        
        doc = application.Documents.Open(word_file)
        
        # Wordのコマンドを実行
        doc.SaveAs(pdf_file, FileFormat=17) # 17 はPDF形式を示す定数
        
        print("変換成功。")
    except Exception as e:
        # 例外が発生した場合、エラーメッセージを表示
        print(f"エラー: {e}", file=sys.stderr)
        # 再度例外を発生させ、プログラムを終了させる
        raise
    finally:
        # docオブジェクトとWordアプリケーションを確実にクローズする
        if doc:
            doc.Close()
        if application:
            application.Quit()

def convert_pdf_to_images(pdf_file, out_dir):
    print(f"Output dir: [{out_dir}]")
    if not os.path.exists(out_dir):
        print(f"Create [{out_dir}]")
        os.makedirs(out_dir)

    print(f"Open [{pdf_file}]")
    doc = fitz.open(pdf_file)
    print(f"Exporting to [{out_dir}]")
    for page_num in range(len(doc)):
        page = doc.load_page(page_num)
        pix = page.get_pixmap()
        output_path = os.path.join(out_dir, f'page_{page_num + 1}.png')
        pix.save(output_path)


if __name__ == '__main__':
    current_dir = os.getcwd()
    word_path = os.path.join(current_dir, infile)
    pdf_path = os.path.join(current_dir, pdf_file)

    # Word文書をPDFに変換
    convert_word_to_pdf(word_path, pdf_path)

    # PDFを画像に変換
    convert_pdf_to_images(pdf_path, out_dir)
