# docx2img.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、Microsoft Word 文書（.docx）を PDF に変換し、その後 PDF を画像（PNG形式）に変換する機能を持っています。具体的には、以下の手順で動作します：
1. 指定された Word 文書を PDF 形式に変換します。
2. 生成された PDF ファイルをページごとに画像ファイル（PNG形式）に変換し、指定された出力ディレクトリに保存します。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています：
- `comtypes`：Microsoft Word アプリケーションとのインターフェースを提供します。
- `fitz`（PyMuPDF）：PDF ファイルを操作し、画像に変換するために使用します。

### インストールコマンド
```bash
pip install comtypes pymupdf
```

### インストール方法
1. 上記のコマンドをターミナルまたはコマンドプロンプトで実行します。
2. `fitz` のインポートに失敗した場合、エラーメッセージが表示され、インストール方法が案内されます。

## 3) 必要な入力ファイル
- `20240815-Coverletter.docx`：変換対象の Microsoft Word 文書。このファイルはプログラムと同じディレクトリに存在する必要があります。

## 4) 実行後に生成される出力ファイル
- `output.pdf`：Word 文書を変換した PDF ファイル。
- `images_doc/` ディレクトリ：PDF の各ページを PNG 形式で保存した画像ファイルが格納されます。ファイル名は `page_1.png`, `page_2.png`, ... の形式になります。

## 5) コマンドラインでの使用例 (Usage)
プログラムを実行するには、以下のコマンドを使用します：
```bash
python docx2img.py
```
このコマンドを実行すると、指定された Word 文書が PDF に変換され、その後 PDF が画像に変換されます。出力は指定されたディレクトリに保存されます。